/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview SetPointFieldEditor class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'bajaux/events', 'bajaux/mixin/batchSaveMixin', 'jquery', 'jquerymobile', 'Promise', 'mobile/util/slot', 'mobile/fieldeditors/fieldeditors', 'mobile/px/widgets/GenericFieldEditor'], function (baja, events, batchSaveMixin, $, jqm, Promise, slotUtil, fe, GenericFieldEditor) {
  "use strict";

  var SAVE_EVENT = events.SAVE_EVENT,
      COMMIT_READY = batchSaveMixin.COMMIT_READY;
  /**
   * @class SetPointFieldEditor
   *
   * The Widget that represents Niagara's 'kitPx:SetPointFieldEditor' Type.
   *
   * @name SetPointFieldEditor
   * @extends GenericFieldEditor
   */

  function SetPointFieldEditor() {
    baja.callSuper(SetPointFieldEditor, this, arguments);
    this.$loadingFe = false;
  }

  baja.subclass(SetPointFieldEditor, GenericFieldEditor);
  /**
   * Load the field editor from the given binding.
   * 
   * @param binding.
   */

  SetPointFieldEditor.prototype.loadSetPoint = function (binding) {
    var ed = this.$fieldEditor; // don't reload if currently modified

    if (ed && ed.isModified()) {
      return;
    } // If we're in the middle of asynchonously loading the field editor then bail
    //TODO: Switchboard ahoy!


    if (this.$loadingFe) {
      return;
    } // map binding to a value/facets           


    var value = binding.getTarget().getObject(),
        facets = slotUtil.getFacets(value),
        that = this;

    if (value.getType().is("baja:IBoolean")) {
      value = Boolean.getBooleanFromIBoolean(value);
    } else if (value.getType().is("baja:INumeric")) {
      value = Number.getNumberFromINumeric(value);
    } else if (value.getType().is("baja:IEnum")) {
      value = baja.Enum.getEnumFromIEnum(value);
    } else if (value.getType().is("baja:IStatusValue")) {
      // assume string point 
      value = value.getValue();
    } // Lazily create or load the field editor


    if (!ed) {
      // Signal we're loading the field editor
      this.$loadingFe = true;
      return fe.makeFor({
        value: value,
        element: this.$dom,
        facets: facets,
        readonly: !that.isEnabled()
      }).then(function (ed) {
        that.$fieldEditor = ed; // Set the field editor to readonly if need be
        //fe.setReadonly(!that.isEnabled()); //done in constructor
        // Signal that we've loaded the field editor

        that.$loadingFe = false; // Update binding since the field editor is loaded asynchronously and
        // the target may have changed. Therefore, we should reload the value.

        return binding.update();
      })["catch"](function (err) {
        baja.error("Failed to create field editor: " + err);
      });
    } else {
      ed.facets = facets;
      return ed.load(value);
    }
  };
  /**
   * Save the Widget
   *
   * @param {Object} [params]
   * @param {baja.comm.Batch} [params.batch] the batch to use to save the
   * field editor
   * @param {Function} [params.progressCallback] the progress callback
   * to notify that the batch is ready to commit
   * @returns {Promise}
   */


  SetPointFieldEditor.prototype.save = function (params) {
    var that = this,
        fe = that.$fieldEditor,
        batch = params && params.batch,
        progressCallback = params && params.progressCallback;

    if (fe && fe.isModified()) {
      return fe.read().then(function (value) {
        var found = false,
            prom; // The the SetPointBinding

        that.getSlots().properties().is("kitPx:SetPointBinding").eachValue(function (binding) {
          found = true; // Call save on the SetPointBinding

          prom = binding.saveSetPoint({
            value: value,
            batch: batch
          }).then(function () {
            fe.setModified(false);
            fe.trigger(SAVE_EVENT);
          });

          if (progressCallback) {
            progressCallback(COMMIT_READY);
          } // Make sure this only happens once so return true


          return true;
        });

        if (!found) {
          throw new Error("Could not find valid SetPointBinding");
        }

        return prom;
      });
    } else {
      return Promise.resolve();
    }
  };

  return SetPointFieldEditor;
});
