/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview RootContainer class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'Promise', 'underscore', 'bajaux/mixin/batchSaveMixin', 'mobile/util/mobile/dialogs', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Promise, _, batchSaveMixin, dialogs, pxUtilMobile, Widget) {
  "use strict";

  var COMMIT_READY = batchSaveMixin.COMMIT_READY;
  /**
   * @class RootContainer.
   * 
   * The mobile pane Widget that represents Niagara's 'bajaui:RootContainer' Type.
   * 
   * @name RootContainer
   * @extends Widget
   */

  function RootContainer() {
    baja.callSuper(RootContainer, this, arguments);
    this.$savableWidgets = [];
  }

  baja.subclass(RootContainer, Widget);
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   * 
   *
   * @param {Object} dom DOM element to append content too.
   */

  RootContainer.prototype.load = function (dom) {
    this.$dom = $("<div></div>");
    this.$dom.appendTo(dom);
  };
  /**
   * Add a Widget that can be modified and saved.
   * 
   * Any Widget added must have an 'isModified' and 'save' method. 
   *
   * @param {Widget} widget
   */


  RootContainer.prototype.addSavableWidget = function (widget) {
    if (!this.$savableWidgets.contains(widget)) {
      // Check we have the correct methods defined on this objects
      if (typeof widget.isModified !== "function") {
        throw new Error("Could not find 'isModified' method on modify widget");
      }

      if (typeof widget.save !== "function") {
        throw new Error("Could not find 'save' method on modify widget");
      }

      if (typeof widget.clearModified !== "function") {
        throw new Error("Cound not find 'clearModified' method on modify widget");
      }

      this.$savableWidgets.push(widget);
    }
  };
  /**
   * Save any Widgets that have been modified.
   *
   * @returns {Promise} to be resolved when all modified widgets have been
   * saved
   */


  RootContainer.prototype.saveWidgets = function () {
    var modifiedWidgets = _.filter(this.$savableWidgets, function (widget) {
      return widget.isModified();
    });

    function validateAll() {
      function validateIt(widget) {
        return widget.validate();
      }

      return Promise.all(_.map(modifiedWidgets, validateIt));
    }

    function saveAll() {
      var batch = new baja.comm.Batch(),
          results = _.map(modifiedWidgets, function (widget) {
        var params = {
          batch: batch
        }; // eslint-disable-next-line promise/avoid-new

        var readyToCommit = new Promise(function (resolve, reject) {
          params.progressCallback = function (msg) {
            if (msg === COMMIT_READY) {
              resolve();
            }
          };
        });
        return [readyToCommit, widget.save(params)];
      }),
          commitPromises = _.map(results, function (arr) {
        return arr[0];
      }),
          savePromises = _.map(results, function (arr) {
        return arr[1];
      });

      return Promise.all(commitPromises).then(function () {
        batch.commit();
        return Promise.all(savePromises);
      });
    }

    if (modifiedWidgets.length) {
      return validateAll().then(saveAll);
    } else {
      return Promise.resolve();
    }
  };
  /**
   * Refresh the page.
   */


  RootContainer.prototype.refresh = function () {
    var that = this; // eslint-disable-next-line promise/avoid-new

    return new Promise(function (resolve, reject) {
      pxUtilMobile.saveModifyQuestion(that, function yesNo() {
        resolve();
        baja.runAsync(function () {
          window.location.reload(
          /*forceGet*/
          false);
        });
      }, function cancel() {
        resolve();
      });
    });
  };
  /**
   * Return true if any of the widgets are modified and hence can be saved.
   *
   * @return {Boolean}
   */


  RootContainer.prototype.isWidgetTreeModified = function () {
    return _.some(this.$savableWidgets, function (w) {
      return w.isModified();
    });
  };
  /**
   * Clear down the modified state of all the saveable Widgets in the Widget tree.
   */


  RootContainer.prototype.clearWidgetTreeModified = function () {
    // Clear the modified state of all the Widgets
    baja.iterate(this.$savableWidgets, function (widget) {
      if (widget.isModified()) {
        widget.clearModified();
      }
    });
  };
  /**
   * Return the PxPage for this Widget tree
   *
   * @return PxPage
   */


  RootContainer.prototype.getPxPage = function () {
    return this.$pxPage;
  };

  return RootContainer;
});
