function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Picture class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */

/**
 * @private
 * @module mobile/px/widgets/Picture
 */
define(['baja!', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/util.px', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Promise, pxUtil, Widget) {
  "use strict";

  var calculateImageDimensions = pxUtil.calculateImageDimensions,
      getHalign = pxUtil.getHalign,
      getImageOrd = pxUtil.getImageOrd,
      getScaledLayoutCSS = pxUtil.getScaledLayoutCSS,
      getValign = pxUtil.getValign,
      setImageSrc = pxUtil.setImageSrc;
  var PICTURE_HTML = "<div class='widgetPicture'><span class='bajaImage'></span></div>";
  /**
   * Updates the src and layout of the Picture's <code>&lt;img&gt;</code> tag.
   * Called whenever there is an update to the Picture's <code>image</code> or
   * <code>scale</code> properties.
   *
   * @private
   * @returns {Promise}
   */

  function updateImage(pic) {
    var imgOrd = getImageOrd(pic),
        imgDom = pic.$imgDom;

    if (!imgOrd) {
      /* 
       * no image to show. 
       */
      imgDom.hide();
    } else if (pic.isAbsolutelyPositioned()) {
      var imgSrc = imgOrd.toUri();
      /* 
       * we are absolutely positioned, so layout according to size and scale.
       * we could show and then asynchronously update the layout css, but 
       * chrome is persnickety about svg rendering and will scale it wrong.
       */

      return Promise.all([calculateImageDimensions(imgSrc), setImageSrc(imgDom, imgOrd)]).then(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 1),
            _ref2$ = _slicedToArray(_ref2[0], 2),
            imgW = _ref2$[0],
            imgH = _ref2$[1];

        var layout = pic.get('layout'),
            outerWidth = layout.getWidth(),
            outerHeight = layout.getHeight(),
            innerWidth = imgW,
            innerHeight = imgH,
            halign = pic.get('halign').getTag(),
            valign = pic.get('valign').getTag(),
            scale = pic.get('scale').getTag(),
            css = getScaledLayoutCSS(outerWidth, outerHeight, innerWidth, innerHeight, halign, valign, scale, imgSrc);
        imgDom.css(css).show();
      });
    } else {
      /*
       * we are in a fluid mobile layout, so no scaling.
       */
      return setImageSrc(imgDom, imgOrd).then(function () {
        return imgDom.show();
      });
    }

    return Promise.resolve();
  }
  /**
   * The Widget that represents Niagara's 'bajaui:Picture' Type.
   * 
   * @private
   * @class
   * @alias module:mobile/px/widgets/Picture
   * @extends module:mobile/px/widgets/Widget
   */


  var Picture = function Picture() {
    Widget.apply(this, arguments);
    this.$imgDom = null;
  };

  Picture.prototype = Object.create(Widget.prototype);
  Picture.prototype.constructor = Picture;
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   * 
   * By default, this method throws an error as it's designed to be overridden.
   * 
   * Anything that implements this method should assign the associated DOM element for the
   * Widget to the '$dom' attribute.
   *
   * @param {Object} dom DOM element to append content to.
   */

  Picture.prototype.load = function (dom) {
    var _this = this;

    var newDom = this.$dom = $(PICTURE_HTML);
    this.$imgDom = newDom.find(".bajaImage");
    newDom.appendTo(dom);
    dom.on('click', '.bajaImage', function () {
      _this.handleEvent('click');

      return false;
    });
  }; // TODO: Support stretch and animate (although animate will probably prove to be impossible)

  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */


  Picture.prototype.doUpdate = function (hasUpdate) {
    var dom = this.$dom; // Horizontal alignment

    if (hasUpdate("halign")) {
      dom.css("text-align", getHalign(this));
    } // Vertical alignment


    if (hasUpdate("valign")) {
      dom.css("vertical-align", getValign(this));
    }

    return (hasUpdate("image") || hasUpdate("scale")) && updateImage(this);
  };

  return Picture;
});
