/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview LogoffButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'lex!mobile', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Button'], function (baja, lexs, $, jqm, Promise, pxUtilMobile, Button) {
  "use strict";

  var saveModifyQuestion = pxUtilMobile.saveModifyQuestion,
      callSuper = baja.callSuper,
      mobileLex = lexs[0];
  /**
   * @class LogoffButton
   *
   * The Widget that represents Niagara's 'kitPx:LogoffButton' Type.
   *
   * @name LogoffButton
   * @extends Button
   */

  function LogoffButton() {
    callSuper(LogoffButton, this, arguments);
  }

  baja.subclass(LogoffButton, Button);
  /**
   * Called when the widget is first loaded.
   */

  LogoffButton.prototype.load = function () {
    callSuper("load", LogoffButton, this, arguments); // By default, always set this as enabled when first loaded.

    this.setEnabled(true);
  };
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Function} hasUpdate
   */


  LogoffButton.prototype.doUpdate = function (hasUpdate) {
    var that = this;
    return Promise.resolve(callSuper("doUpdate", LogoffButton, this, arguments)).then(function () {
      if (hasUpdate("text")) {
        // The text always says logoff
        that.setText(mobileLex.get("logoff"));
      }
    });
  };
  /**
   * Handle a UI Widget event.
   */


  LogoffButton.prototype.doHandleEvent = function (eventName) {
    saveModifyQuestion(this, function logoff() {
      window.location.assign("/logout");
    }); // Return true so the event doesn't filter down to the bindings

    return true;
  };

  return LogoffButton;
});
