/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview LocalizableLabel class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/widgets/Label'], function (baja, $, jqm, Promise, Label) {
  "use strict";

  var callSuper = baja.callSuper;
  /**
   * @class LocalizableLabel
   *
   * The Widget that represents Niagara's 'kitPx:LocalizableLabel' Type.
   *
   * @name LocalizableLabel
   * @extends HyperlinkLabel
   */

  function LocalizableLabel() {
    callSuper(LocalizableLabel, this, arguments);
    this.$bkDom = null;
  }

  baja.subclass(LocalizableLabel, Label);
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */

  LocalizableLabel.prototype.load = function (dom) {
    this.$bkDom = $("<div></div>");
    this.$bkDom.appendTo(dom);
    callSuper("load", LocalizableLabel, this, [this.$bkDom]);
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */


  LocalizableLabel.prototype.doUpdate = function (hasUpdate) {
    var that = this;
    return Promise.resolve(callSuper("doUpdate", LocalizableLabel, that, arguments)).then(function () {
      // Background image
      if (hasUpdate("backgroundImage")) {
        var bkImg = that.getBackgroundImage().encodeToString();
        bkImg = bkImg === "null" ? "" : bkImg;
        that.$bkDom.css("background", bkImg ? "url(/ord?" + bkImg + ") no-repeat center center" : "");
      }
    });
  };

  return LocalizableLabel;
});
