/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview LocalizableButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'lex!mobile', 'jquery', 'jquerymobile', 'mobile/util/mobile/dialogs', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Button'], function (baja, lexs, $, jqm, dialogs, pxUtilMobile, Button) {
  "use strict";

  var hyperlink = pxUtilMobile.hyperlink,
      callSuper = baja.callSuper,
      mobileLex = lexs[0];
  /**
   * @class LocalizableButton
   *
   * The Widget that represents Niagara's 'kitPx:LocalizableButton' Type.
   *
   * @name LocalizableButton
   * @extends Button
   */

  function LocalizableButton() {
    callSuper(LocalizableButton, this, arguments);
  }

  baja.subclass(LocalizableButton, Button); // TODO: Support background image

  /**
   * Handle a UI Widget event.
   */

  LocalizableButton.prototype.doHandleEvent = function (eventName) {
    var that = this,
        hlink = that.getHyperlink();

    if (hlink === baja.Ord.DEFAULT) {
      return false;
    }

    function doHyperlink() {
      hyperlink(that, hlink);
    }

    if (this.getConfirmRequired()) {
      dialogs.yesNo({
        content: mobileLex.get({
          key: "hyperlinkTo",
          args: hlink
        }),
        yes: function yes(cb) {
          doHyperlink();
          cb.ok();
        }
      });
    } else {
      doHyperlink();
    } // Return true so the event doesn't filter down to the bindings


    return true;
  };

  return LocalizableButton;
});
