/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ImageButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'Promise', 'mobile/px/util.px', 'mobile/px/widgets/Button'], function (baja, $, jqm, Promise, pxUtil, Button) {
  "use strict";

  var setImageSrc = pxUtil.setImageSrc,
      callSuper = baja.callSuper;
  /**
   * @class Image Button.
   *
   * The Widget that represents Niagara's 'kitPx:ImageButton' Type.
   *
   * @name ToggleButton
   * @extends Widget
   */

  function ImageButton() {
    callSuper(ImageButton, this, arguments);
  }

  baja.subclass(ImageButton, Button);
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */

  ImageButton.prototype.doUpdate = function (hasUpdate) {
    var that = this,
        textDom = that.$textDom,
        imgDom = that.$imgDom,
        normalStr,
        disabledStr,
        imageStr,
        isDisabled = false;
    return Promise.resolve(callSuper("doUpdate", ImageButton, that, arguments)).then(function () {
      if (hasUpdate("normal") || hasUpdate("disabled")) {
        disabledStr = that.getDisabled().toString();

        if (!(disabledStr === "" || disabledStr === "null") && !that.isEnabled()) {
          normalStr = disabledStr;
          isDisabled = true;
        } else {
          normalStr = that.getNormal().toString();
        }

        if (normalStr === "" || normalStr === "null") {
          // Image
          imageStr = that.getImage().toString();
          imgDom.toggle(imageStr && imageStr !== "null");
          textDom.show();
        } else {
          // Cancel any blinking since this doesn't work in Workbench Px anyway
          that.$blinkTicket.cancel();
          textDom.toggle(isDisabled);
          setImageSrc(imgDom, "/ord?" + normalStr.toString());
          imgDom.show();
        }
      }
    });
  };

  return ImageButton;
});
