function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ForwardButton class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */

/**
 * @private
 * @module mobile/px/widgets/ForwardButton
 */
define(['baja!', 'lex!mobile', 'mobile/px/util.px.mobile', 'mobile/px/widgets/Button'], function (baja, lexs, pxUtilMobile, Button) {
  "use strict";

  var saveModifyQuestion = pxUtilMobile.saveModifyQuestion,
      _lexs = _slicedToArray(lexs, 1),
      mobileLex = _lexs[0];
  /**
   * The Widget that represents Niagara's 'kitPx:ForwardButton' Type.
   * @private
   * @class
   * @alias module:mobile/px/widgets/ForwardButton
   * @extends module:mobile/px/widgets/Button
   */


  var ForwardButton = function ForwardButton() {
    Button.apply(this, arguments);
  };

  ForwardButton.prototype = Object.create(Button.prototype);
  ForwardButton.prototype.constructor = ForwardButton;
  /**
   * Called when the widget is first loaded.
   */

  ForwardButton.prototype.load = function () {
    Button.prototype.load.apply(this, arguments); // a ForwardButton is always enabled and always has text "Forward".
    // WB only enables it if there is history to move forward to; for
    // security, JS will not allow us see this info, so always enable and it
    // will just do nothing if there is no forward history

    this.setEnabled(true);
    this.setText(mobileLex.get('forward'));
  };
  /**
   * Handle a UI Widget event.
   */


  ForwardButton.prototype.doHandleEvent = function (eventName) {
    saveModifyQuestion(this, function () {
      return window.history.forward();
    }); // Return true so the event doesn't filter down to the bindings

    return true;
  };

  return ForwardButton;
});
