/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BoundTable class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget', 'mobile/history/table/DataTableView', 'mobile/util/mobile/touchscroll'], function (baja, $, jqm, Widget, DataTableView, touchScroll) {
  "use strict";

  var noop = baja.noop,
      TABLE_HTML = "<div class='boundTable'></div>",
      FOOTER_HTML = '<div class="boundTableFooter" data-role="footer" data-position="fixed">' + '<div data-role="navbar" class="tableNavBar">' + '<ul>' + '<li><a href="#" data-theme="b" class="prevTable" data-icon="arrow-l" data-iconpos="notext"></a></li>' + '<li><a href="#" data-theme="b" class="nextTable" data-icon="arrow-r" data-iconpos="notext"></a></li>' + '</ul>' + '</div>' + '</div>',
      callSuper = baja.callSuper;
  /**
   * @class BoundTable
   *
   * The Widget that represents Niagara's 'bajaui:BoundTable' Type.
   *
   * @name BoundTable
   * @extends Widget
   */

  function BoundTable() {
    callSuper(BoundTable, this, arguments);
    this.$tableDom = null;
  }

  baja.subclass(BoundTable, Widget);
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   * 
   * By default, this method throws an error as it's designed to be overriden.
   * 
   * Anything that implements this method should assign the associated DOM element for the
   * Widget to the '$dom' attribute.
   *
   * @param {Object} DOM element to append content too.
   */

  BoundTable.prototype.load = function (dom) {
    var tableDom = $(TABLE_HTML),
        footerDom = $(FOOTER_HTML);
    tableDom.appendTo(dom);
    footerDom.appendTo(tableDom).trigger('create');
    this.$dom = tableDom;
    this.$footer = footerDom;
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   * @param {Boolean} [firstUpdate] set to true on Widgets first update when the page is first loaded.
   */


  BoundTable.prototype.doUpdate = function (hasUpdate, firstUpdate) {
    // If the table has been already loaded then bail (for performance reasons)
    if (this.$tableLoaded) {
      return;
    } // TODO: Implement table with more styling, limit and offset (next and last buttons) - 
    // just like history App.


    var bindings = []; // Get a list of all the bound TableBindings

    this.getSlots(function (slot) {
      return slot.isProperty() && slot.getType().is("bajaui:TableBinding") && this.get(slot).isBound();
    }).each(function (slot) {
      bindings.push(this.get(slot));
    }); // Bail if there are no bindings

    if (bindings.length === 0) {
      return;
    } // Mark the table as loaded (before any asynchronous network calls happen)


    this.$tableLoaded = true;
    var view = new DataTableView(),
        dom = this.$dom,
        tableContainer = $('<div class="tableContent"/>').prependTo(dom),
        footer = dom.find('div:jqmData(role=footer)');
    return view.initialize(tableContainer).then(function () {
      touchScroll(tableContainer, {
        horiz: true,
        vert: true,
        showBlockade: true
      });
      view.bindFooter(footer);
      return view.load(bindings[0].getOrd());
    }).then(function () {
      tableContainer.height(dom.height() - footer.height());
    });
  };
  /**
   * Load the child Widgets.
   * 
   * {@link baja.Widget#load} must be called before this method is invoked.
   *
   * @function
   */


  BoundTable.prototype.loadChildren = noop;
  return BoundTable;
});
