/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BoundLabel class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Label'], function (baja, $, jqm, Label) {
  "use strict";

  var callSuper = baja.callSuper;
  /**
   * @class BoundLabel.
   *
   * The Widget that represents Niagara's 'kitPx:BoundLabel' Type.
   *
   * @name BoundLabel
   * @extends Widget
   */

  function BoundLabel() {
    baja.callSuper(BoundLabel, this, arguments);
  }

  baja.subclass(BoundLabel, Label);
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */

  BoundLabel.prototype.doUpdate = function (hasUpdate) {
    // Padding
    if (hasUpdate("padding")) {
      this.applyCssFromSlot("padding", this.$dom,
      /*excess*/
      this.isAbsolutelyPositioned() ? 0 : 7);
    }

    return callSuper("doUpdate", BoundLabel, this, arguments);
  };

  return BoundLabel;
});
