/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BorderPane class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Widget) {
  "use strict";

  var callSuper = baja.callSuper;
  /**
   * @class BorderPane.
   * 
   * The mobile pane Widget that represents Niagara's 'bajaui:BorderPane' Type.
   * 
   * @name BorderPane
   * @extends Widget
   */

  function BorderPane() {
    callSuper(BorderPane, this, arguments);
  }

  baja.subclass(BorderPane, Widget);
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   *
   * @param {Object} dom DOM element to append content too.
   */

  BorderPane.prototype.load = function (dom) {
    this.$dom = $("<div class='borderPane'></div>");
    this.$dom.appendTo(dom);
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */


  BorderPane.prototype.doUpdate = function (hasUpdate) {
    var dom = this.$dom; // TODO: label, border
    // Fill

    if (hasUpdate("fill")) {
      this.applyCssFromSlot("fill", {
        dom: dom,
        colorSelector: "background",
        imageSelector: "background"
      });
    } // Margin


    if (hasUpdate("margin")) {
      this.applyCssFromSlot("margin", dom, 0, "margin");
    } // Padding


    if (hasUpdate("padding")) {
      this.applyCssFromSlot("padding", dom, 0, "padding");
    }
  };

  return BorderPane;
});
