/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview BasicMobilePane class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Widget) {
  "use strict";

  var callSuper = baja.callSuper;
  /**
   * @class BasicMobilePane.
   * 
   * The mobile pane Widget that represents Niagara's 'mobile:BasicMobilePane' Type.
   * 
   * @name BasicMobilePane
   * @extends Widget
   */

  function BasicMobilePane() {
    callSuper(BasicMobilePane, this, arguments);
  }

  baja.subclass(BasicMobilePane, Widget);
  /**
   * Append the Widget's DOM content onto the specified DOM element.
   * 
   *
   * @param {Object} dom DOM element to append content too.
   */

  BasicMobilePane.prototype.load = function (dom) {
    this.$dom = $("<div class='basicMobilePane'></div>");
    this.$dom.appendTo(dom);
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   */


  BasicMobilePane.prototype.doUpdate = function (hasUpdate) {
    var dom = this.$dom; // Update padding

    if (hasUpdate("padding")) {
      this.applyCssFromSlot("padding", dom, 0, "padding");
    } // Update row gap


    if (hasUpdate("rowGap")) {
      var rowGap = this.getRowGap() + "px"; // Set the pane's margin bottom and top to each child

      dom.children().each(function () {
        $(this).css("margin-bottom", rowGap);
      });
    }
  };

  return BasicMobilePane;
});
