/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Bargraph class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'jquery', 'jquerymobile', 'mobile/px/widgets/Widget'], function (baja, $, jqm, Widget) {
  "use strict";

  var noop = baja.noop,
      callSuper = baja.callSuper,
      bargraphHtml = "<div class='bargraph'>" + "<div class='innerBargraph'>" + "<div class='bargraphBar'></div>" + "</div'>" + "</div>",
      bargraphScaleHtml = "<div class='bargraphScale'></div>";
  /**
   * @class Bargraph
   *
   * The Widget that represents Niagara's 'kitPx:Bargraph' Type.
   *
   * @name Bargraph
   * @extends Widget
   */

  var Bargraph = function Bargraph() {
    callSuper(Bargraph, this, arguments);
    this.$dom = null;
    this.$bargraphDom = null;
    this.$barDom = null;
  };

  baja.subclass(Bargraph, Widget);

  Bargraph.prototype.load = function (dom) {
    var that = this,
        outerDom = $(bargraphHtml),
        bargraphDom = $(".innerBargraph", outerDom),
        barDom = $(".bargraphBar", outerDom);

    if (!that.isAbsolutelyPositioned()) {
      bargraphDom.css("padding", "14px 14px");
    } else {
      bargraphDom.css({
        "width": "100%",
        "height": "100%"
      });
    } // Set up click handler


    outerDom.click(function () {
      that.handleEvent("click"); // Return false to override default click behavior

      return false;
    });
    dom.append(outerDom);
    that.$dom = outerDom;
    that.$bargraphDom = bargraphDom;
    that.$barDom = barDom;
  };
  /**
   * Update the DOM associated with this Widget.
   *
   * @param {Function} hasUpdate called to test whether a 
   *                               given Property can update the DOM.
   * @param {Boolean} [firstUpdate] set to true on Widgets first update when the page is first loaded.
   */


  Bargraph.prototype.doUpdate = function (hasUpdate, firstUpdate) {
    var that = this,
        dom = that.$dom,
        bargraphDom = that.$bargraphDom,
        barDom = that.$barDom,
        isVertical = that.getOrientation().is("vertical"),
        min = that.getMin(),
        max = that.getMax(),
        value,
        scale,
        scaleDom,
        scaleNum,
        perc,
        i;

    if (hasUpdate("background")) {
      that.applyCssFromSlot("background", {
        dom: bargraphDom,
        colorSelector: "background",
        imageSelector: "background"
      });
    }

    if (hasUpdate("foreground")) {
      that.applyCssFromSlot("foreground", {
        dom: dom,
        colorSelector: "border",
        prefix: "1px solid "
      });
    } // Fill


    if (hasUpdate("fill")) {
      that.applyCssFromSlot("fill", {
        dom: barDom,
        colorSelector: "background",
        imageSelector: "background"
      });
    } // Update bar chart value


    if (hasUpdate("value") || hasUpdate("min") || hasUpdate("max") || hasUpdate("vertical")) {
      value = that.getValue();
      value = Math.max((value - min) / (max - min) * 100, 0);
      value = String(value) + "%";

      if (isVertical) {
        barDom.css({
          "width": "100%",
          "height": value,
          "bottom": "0px"
        });
      } else {
        barDom.css({
          "width": value,
          "height": "100%",
          "top": "0px"
        });
      }
    } // Scale


    if (hasUpdate("scale") || hasUpdate("scaleVisible") || hasUpdate("orientation") || hasUpdate("foreground")) {
      // Remove all existing scales from the DOM       
      $(".bargraphScale", bargraphDom).remove();

      if (that.getScaleVisible()) {
        scale = that.getScale();
        scale = scale <= 0 ? 10 : scale;
        scaleNum = (max - min) / scale;
        scaleNum = scaleNum <= 0 ? 10 : scaleNum;

        for (i = 1; i < scaleNum; ++i) {
          scaleDom = $(bargraphScaleHtml);
          perc = 100 / scaleNum * i + "%";

          if (isVertical) {
            scaleDom.css({
              "position": "absolute",
              "right": "0px",
              "width": "4px",
              "height": "1px",
              "bottom": perc
            });
          } else {
            scaleDom.css({
              "position": "absolute",
              "bottom": "0px",
              "height": "4px",
              "width": "1px",
              "left": perc
            });
          } // Color of the scale


          that.applyCssFromSlot("foreground", {
            dom: scaleDom,
            colorSelector: "background"
          });
          bargraphDom.append(scaleDom);
        }
      }
    }
  };
  /**
   * Load the child Widgets.
   * 
   * {@link baja.Widget#load} must be called before this method is invoked.
   *
   * @function
   */


  Bargraph.prototype.loadChildren = noop;
  return Bargraph;
});
