function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Utility methods for the Px App.
 *
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'baja!bajaui:Widget', 'lex!baja', 'jquery', 'Promise', 'bajaux/icon/iconUtils', 'mobile/util/mobile/mobile'], function (baja, types, lexs, $, Promise, iconUtils, mobileUtil) {
  "use strict";

  var escapeHtml = mobileUtil.escapeHtml,
      toHtml = iconUtils.toHtml,
      _lexs = _slicedToArray(lexs, 1),
      bajaLex = _lexs[0],
      _types = _slicedToArray(types, 1),
      widgetType = _types[0];
  /**
   * @private
   * @exports module:mobile/px/util
   */


  var exports = {};

  exports.getWidgetType = function () {
    return widgetType;
  };

  exports.hasUpdateAll = function () {
    return true;
  };

  exports.hasUpdateEnabled = function (propName) {
    return propName === "enabled";
  };
  /**
   * Return the color code for the given Status.
   *
   * @name niagara.util.px.getStatusColor
   * @function
   *
   * @param {Object} obj Object Literal for the method's arguments.
   * @param {String} [obj.statusName] if specified, the color for the given status will be returned.
   * @param {baja.Status} [obj.status] if specified, the color for the status will be returned.
   * @param {String} [obj.defaultColor] returned if no color can be found for the given status.
   * @param {Boolean} obj.isForeground request foreground or background color.
   * @return {string} resolved color value.
   */


  exports.getStatusColor = function (obj) {
    var _obj$defaultColor = obj.defaultColor,
        defaultColor = _obj$defaultColor === void 0 ? null : _obj$defaultColor,
        isForeground = obj.isForeground,
        status = obj.status;

    if (obj.status) {
      var statusName;

      if (status.isDisabled()) {
        statusName = "disabled";
      } else if (status.isFault()) {
        statusName = "fault";
      } else if (status.isDown()) {
        statusName = "down";
      } else if (status.isAlarm()) {
        statusName = "alarm";
      } else if (status.isStale()) {
        statusName = "stale";
      } else if (status.isOverridden()) {
        statusName = "overridden";
      } else {
        return defaultColor;
      }

      return exports.getStatusColor({
        statusName: statusName,
        isForeground: isForeground,
        defaultColor: defaultColor
      });
    }

    return bajaLex.get({
      key: "Status." + obj.statusName + (isForeground ? ".fg" : ".bg"),
      def: defaultColor
    });
  };
  /**
   * Return the brush for the given Status.
   *
   * @name niagara.util.px.getStatusBrush
   * @function
   *
   * @param {Object} obj Object Literal for method arguments.
   * @param {String} obj.statusName
   * @param {Boolean} obj.isForeground request foreground or background color.
   * @return {baja.Simple|null} resolved `gx:Brush`
   */


  exports.getStatusBrush = function (obj) {
    var statusColor = exports.getStatusColor(obj);
    return statusColor && baja.$('gx:Brush', statusColor);
  };
  /**
   * @param {module:mobile/px/widgets/Widget} widget
   * @returns {baja.Ord|null}
   */


  exports.getImageOrd = function (widget) {
    var imageStr = String(widget.get('image'));
    return imageStr === 'null' ? null : baja.Ord.make(imageStr);
  };
  /**
   * NCCB-5908: webkit strikes again with poor SVG rescaling. the hide()
   * and offset() force a browser reflow as a workaround for the following
   * bug:
   * https://code.google.com/p/chromium/issues/detail?id=269446
   * 
   * TODO: linked bug is fixed, verify we can remove this
   *
   * @param {JQuery} dom
   * @param {baja.Ord} srcOrd
   * @returns {Promise}
   */


  exports.setImageSrc = function (dom, srcOrd) {
    var visible = dom.css('display') !== 'none',
        ordStr = String(srcOrd),
        isSvg = ordStr.toLowerCase().lastIndexOf('.svg') === ordStr.length - 4;

    if (isSvg) {
      dom.hide().offset();
    }

    return toHtml(srcOrd).then(function (html) {
      dom.html(html);

      if (isSvg) {
        dom.toggle(visible);
      }
    });
  };
  /**
   * @param {module:mobile/px/widgets/Widget} widget
   * @returns {Promise.<boolean>} promise to be resolved with a boolean: true
   * if the image was either shown or hidden
   */


  exports.updateImage = function (widget) {
    var imageOrd = exports.getImageOrd(widget),
        imgDom = widget.$imgDom;

    if (imageOrd) {
      return exports.setImageSrc(imgDom, imageOrd).then(function () {
        if (!widget.$imgDomShown) {
          imgDom.show();
          return widget.$imgDomShown = true;
        }
      });
    } else {
      if (widget.$imgDomShown) {
        imgDom.hide();
        widget.$imgDomShown = false;
        return Promise.resolve(true);
      }
    } // If the text to icon alignment is center then we also need to indicate
    // the image show state has changed


    return Promise.resolve(widget.get('textToIconAlign').is("center"));
  };
  /**
   * @param {module:mobile/px/widgets/Widget} widget
   * @param {JQuery} dom
   */


  exports.updateImagePosition = function (widget, dom) {
    var domContents = dom.children().detach(),
        textDom = widget.$textDom.detach(),
        imgDom = widget.$imgDom.detach(),
        tAlign = widget.get('textToIconAlign'),
        gap = widget.$imgDomShown && widget.$textDomShown ? String(widget.get('textIconGap')) + "px" : "0px",
        imgOrd = exports.getImageOrd(widget),
        img,
        imgCell; // Reference Margin CSS: top, right, bottom, left 

    if (tAlign.is("center")) {
      textDom.css({
        "margin": 0,
        "display": "block",
        "text-align": "center"
      });
      imgCell = $('<div/>').css({
        "display": "table-cell",
        "vertical-align": "middle",
        "background-image": imgOrd ? "url('" + imgOrd.toUri() + "')" : "",
        "background-repeat": "no-repeat",
        "background-position": "center"
      }).append(textDom);
      domContents = $('<div/>').css({
        display: "inline-block",
        "vertical-align": "inherit"
      }).append(imgCell);

      if (imgOrd) {
        img = new Image();

        img.onload = function () {
          imgCell.css({
            "min-width": img.width,
            height: img.height
          });
        };

        img.src = imgOrd.toUri();
      }
    } else if (tAlign.is("right")) {
      textDom.css({
        display: widget.$textDomShown ? "inline" : "none",
        margin: "0px 0px 0px " + gap
      });
      domContents = imgDom.add(textDom);
    } else if (tAlign.is("left")) {
      textDom.css({
        display: widget.$textDomShown ? "inline" : "none",
        margin: "0px " + gap + " 0px 0px"
      });
      domContents = textDom.add(imgDom);
    } else if (tAlign.is("top")) {
      textDom.css({
        display: widget.$textDomShown ? "block" : "none",
        margin: "0px 0px " + gap + " 0px"
      });
      domContents = textDom.add(imgDom);
    } else if (tAlign.is("bottom")) {
      textDom.css({
        display: widget.$textDomShown ? "block" : "none",
        margin: gap + " 0px 0px 0px"
      });
      domContents = imgDom.add(textDom);
    }

    dom.html(domContents);
  };
  /**
   * Resolve the text for the widget asynchronously.
   *
   * @param widget the Widget the text is being retrieved from.
   * @returns {Promise} to be resolved with the widget's text
   */


  function getTextAsync(widget) {
    // If there's valid normal text then use that
    var text = widget.get("text");

    if (text.length > 0) {
      return Promise.resolve(text);
    } // Do Format if we need too


    if (widget.getTextFormat) {
      var textFormat = widget.getTextFormat();

      if (textFormat !== baja.Format.DEFAULT) {
        return textFormat.format();
      }
    }

    return Promise.resolve('');
  }
  /**
   * Update the Widget's text asynchronously
   *
   * @param widget the Widget the text is being retrieved from.
   * @returns {Promise} to be resolved with true if the text show state of the
   * widget has changed
   */


  exports.updateText = function (widget) {
    return getTextAsync(widget).then(function (text) {
      text = escapeHtml(text);
      text = text.replace(/\n/g, "<br />");
      var textDom = widget.$textDom;

      if (textDom.is('input')) {
        textDom.val(text);
      } else {
        textDom.html(text);
      }

      var textShowStateChanged = false; // The text DOM being hidden or shown is done further in textToIconAlign...

      if (text === "") {
        if (widget.$textDomShown) {
          widget.$textDomShown = false;
          textShowStateChanged = true;
        }
      } else {
        if (!widget.$textDomShown) {
          widget.$textDomShown = true;
          textShowStateChanged = true;
        }
      }

      return textShowStateChanged;
    });
  }; ////////////////////////////////////////////////////////////////
  // Layout utility functions
  ////////////////////////////////////////////////////////////////  

  /**
   * Adds the CSS3 transforms to the CSS object, including all vendor prefixes 
   * and IE8 filter malarkey.
   * 
   * @param {Object} cssObj the CSS object to add rules to
   * @param {Number} hScale horizontal scale factor
   * @param {Number} vScale vertical scale factor
   */


  exports.addScaling = function addScaling(cssObj, hScale, vScale) {
    var i,
        prefixes = ['', '-moz-', '-webkit-', '-ms-'];

    for (i = 0; i < prefixes.length; i++) {
      cssObj[prefixes[i] + 'transform'] = 'scale(' + hScale + ',' + vScale + ')';
      cssObj[prefixes[i] + 'transform-origin'] = 'left top';
    }

    cssObj['-ms-filter'] = cssObj.filter = "progid:DXImageTransform.Microsoft.Matrix(M11=" + hScale + ", M12=0, M21=0, M22=" + vScale + ", SizingMethod='auto expand')";
  };
  /**
   * This function applies to widgets that support dynamic scaling of an 
   * internal element - currently, Pictures and CanvasPanes. It calculates
   * the CSS necessary to scale and align the internal element within the
   * absolutely positioned outer frame. 
   * 
   * @param {Number} outerWidth width of absolutely positioned outer element
   * @param {Number} outerHeight height of absolutely positioned outer element
   * @param {Number} innerWidth width of scaled/aligned inner element
   * @param {Number} innerHeight height of scaled/aligned inner element
   * @param {String} halign the horizontal alignment - should correspond to
   * a BHalign tag (left, center, right, fill)
   * @param {String} valign the vertical alignment - should correspond to
   * a BValign tag (top, center, bottom, fill)
   * @param {String} scale the scale mode - should correspond to a BScaleMode
   * tag (none, fit, fitRatio, fitWidth, fitHeight)
   * @param {String} [imgSrc] the imgSrc- will be used to determine if additional
   * svg transforms should be used (if imgSrc ends in ".svg").
   * @return {Object} an object with <code>display</code>, <code>width</code>, 
   * <code>height</code>, <code>margin-top</code>, <code>margin-left</code> and
   * <code>transform</code> properties. This should be applied to the inner
   * element to be scaled.
   */


  exports.getScaledLayoutCSS = function (outerWidth, outerHeight, innerWidth, innerHeight, halign, valign, scale, imgSrc) {
    var imgRatio,
        desiredWidth,
        desiredHeight,
        marginTop,
        marginLeft,
        overrideTop,
        overrideLeft,
        transform,
        cssObj,
        isSvg = imgSrc ? String(imgSrc).toLowerCase().split(".").pop() === "svg" : false;

    switch (scale) {
      case 'none':
        desiredWidth = innerWidth;
        desiredHeight = innerHeight;
        break;

      case 'fit':
        desiredWidth = outerWidth;
        desiredHeight = outerHeight;

        if (isSvg) {
          desiredWidth = innerWidth;
          desiredHeight = innerHeight;
          var heightRatio = outerHeight / innerHeight;
          var widthRatio = outerWidth / innerWidth;
          overrideTop = (outerHeight - innerHeight) / 2;
          overrideLeft = (outerWidth - innerWidth) / 2;
          transform = "scale(" + widthRatio + "," + heightRatio + ")";
        }

        break;

      case 'fitHeight':
        desiredWidth = innerWidth;
        desiredHeight = outerHeight;

        if (isSvg) {
          imgRatio = outerHeight / innerHeight; //This part is tricky, we never want to make the height smaller

          if (imgRatio > 1) {
            transform = "scale(1," + imgRatio + ")";
          } else {
            transform = "scale(" + 1 / imgRatio + ",1)";
          }
        }

        break;

      case 'fitWidth':
        desiredWidth = outerWidth;
        desiredHeight = innerHeight;

        if (isSvg) {
          imgRatio = outerWidth / innerWidth; //This part is tricky, we never want to make the width smaller

          if (imgRatio > 1) {
            transform = "scale(" + imgRatio + ",1)";
          } else {
            transform = "scale(1," + 1 / imgRatio + ")";
          }
        }

        break;

      case 'fitRatio':
        //scale image down only enough to fit within picture borders
        imgRatio = Math.min(outerWidth / innerWidth, outerHeight / innerHeight);
        desiredWidth = innerWidth * imgRatio;
        desiredHeight = innerHeight * imgRatio;
        break;
    }
    /*
     * align using margins, since text-align won't quite do it if the image is
     * larger than the Picture itself
     */


    switch (halign) {
      case 'left':
        marginLeft = 0;
        break;

      case 'center':
        marginLeft = (outerWidth - desiredWidth) / 2;
        break;

      case 'right':
      case 'fill':
        marginLeft = outerWidth - desiredWidth;
        break;
    }

    switch (valign) {
      case 'top':
        marginTop = 0;
        break;

      case 'center':
        marginTop = (outerHeight - desiredHeight) / 2;
        break;

      case 'bottom':
      case 'fill':
        marginTop = outerHeight - desiredHeight;
        break;
    }

    cssObj = {
      display: 'block',
      width: desiredWidth,
      height: desiredHeight,
      'margin-top': marginTop,
      'margin-left': marginLeft
    };

    if (overrideTop) {
      cssObj['margin-top'] = overrideTop;
    }

    if (overrideLeft) {
      cssObj['margin-left'] = overrideLeft;
    }

    if (transform) {
      cssObj.transform = transform;
    }

    return cssObj;
  };
  /**
   * Get a vertical align value for the widget, derived from the widget's
   * valign property.
   * 
   * @param {module:mobile/px/widgets/Widget} widget
   * @return {String} a vertical-align CSS value ('top', 'middle', 'bottom')
   */


  exports.getValign = function (widget) {
    if (widget.has('valign')) {
      var valign = widget.get('valign').getTag().toLowerCase();

      if (valign === "fill" || valign === "center") {
        valign = "middle";
      }

      return valign;
    }
  };
  /**
   * Get a horizontal align value for the widget, derived from the widget's
   * halign property.
   * 
   * @param {Widget} widget
   * @return {String} a text-align CSS value ('left', 'center', 'right')
   */


  exports.getHalign = function (widget) {
    if (widget.has('halign')) {
      var halign = widget.get('halign').getTag().toLowerCase();

      if (halign === 'fill') {
        halign = 'center';
      }

      return halign;
    }
  };
  /**
   * Asynchronously calculates image width and height.
   * 
   * @param {String} imgSrc the path where the image lives
   * @returns {Promise} promise to be resolved with an array containing image
   * width and height
   */


  exports.calculateImageDimensions = function (imgSrc) {
    // eslint-disable-next-line promise/avoid-new
    return new Promise(function (resolve, reject) {
      var img = new Image();

      img.onload = function () {
        resolve([this.width, this.height]);
        img.onload = null;
        img = null;
      };

      img.onerror = reject;
      img.src = imgSrc;
    });
  };

  return exports;
});
