/**
 * @file MobileHxPxView.
 * @copyright 2017 Tridium, Inc. All Rights Reserved.
 * @author JJ Frankovich
 */

/*global niagara */
define(['baja!', 'bajaux/commands/Command', 'lex!mobile', 'jquery', 'Promise', 'mobile/util/mobile/mobile', 'mobile/util/mobile/commands', 'mobile/util/mobile/selectview', 'mobile/util/mobile/pages', 'mobile/util/mobile/views/MobileView', 'mobile/util/mobile/views/PageView', 'mobile/util/mobile/views/PageViewManager', 'nmodule/js/rc/asyncUtils/asyncUtils', 'css!mobile/px/hxPx/mobileHxPx'], function (baja, Command, lexs, $, Promise, mobileUtil, commands, views, pages, MobileView, PageView, PageViewManager, asyncUtils) {
  // Use ECMAScript 5 Strict Mode
  "use strict";

  var MobileHxPxPageView,
      MobileHxPxView,
      MobileHxPxPageViewManager,
      appsMgr,
      mobileLex = lexs[0];

  function getDisplayName(object) {
    return object.getNavDisplayName && object.getNavDisplayName() || object.getNavName && object.getNavName() || object.getFileName && object.getFileName();
  } ////////////////////////////////////////////////////////////////
  //Util
  ////////////////////////////////////////////////////////////////

  /**
   * View HxPx pages in the mobile profile via an iframe.
   *
   * @class
   * @memberOf niagara.px
   * @extends mobile/util/mobile/views/MobileView
   * @private
   */


  MobileHxPxView = baja.subclass(function () {
    baja.callSuper(MobileHxPxView, this, arguments);
  }, MobileView);

  MobileHxPxView.prototype.toDisplayName = function () {
    var navNode = this.value(),
        name = getDisplayName(navNode);
    return Promise.resolve(name || mobileLex.get('pxView'));
  };

  MobileHxPxView.prototype.getSubscriber = function getSubscriber() {//no subscription required
  };

  MobileHxPxView.prototype.doInitialize = function doInitialize(jq) {
    addHyperlinkToEnv(); //add save command since hx fieldeditors can't wait for a modify event

    this.getCommandGroup().add(new Command("%lexicon(mobile:save)%", function () {
      jq.find("iframe")[0].contentWindow.hx.save();
    }));
  };
  /**
   * Add Hyperlink ability to the niagara.env so that iframe hyperlinks work properly
   */


  function addHyperlinkToEnv() {
    window.niagara = window.niagara || {};
    window.niagara.env = window.niagara.env || {};

    window.niagara.env.toHyperlink = window.niagara.env.toHyperlink || function toHyperlink(ordStr) {
      ordStr = ordStr.toString();
      var uri = ordStr.charAt(0) === "/" ? ordStr : baja.Ord.make(ordStr).toUri();
      return Promise.resolve(uri);
    };

    window.niagara.env.hyperlink = function hyperlink(ordStr, assign) {
      var pWin = baja.parentWindow(); // This hyperlink call should look up to the top-most parent window to process
      // the hyperlink, but if none can be found, go ahead and process it.

      if (!pWin || pWin === window || typeof pWin.niagara === 'undefined') {
        return window.niagara.env.toHyperlink(ordStr).then(function (uri) {
          if (typeof assign === "function") {
            assign(uri);
          } else {
            window.location.assign(uri);
          }
        });
      } // Walk up to the top-most parent window that can process the hyperlink


      var potentialParent = baja.parentWindow(pWin); // known issue
      // eslint-disable-next-line no-unmodified-loop-condition

      while (potentialParent && potentialParent !== pWin && typeof potentialParent.niagara !== 'undefined') {
        pWin = potentialParent;
      }

      return pWin.niagara.env.hyperlink(ordStr, assign);
    };
  }

  MobileHxPxView.prototype.doLoad = function doLoad() {
    var ord = this.jq().closest(".ui-page").jqmData('pageData').ord;
    var iframe = $('<iframe width="100%" height="100%" id="hxPxContent" src="/ord/' + ord + '|view:?preferHx=true" onload="require([\'baja!\'], function (baja) {baja.topWindow().$ensureFullScreen(this);});"/>'); //ensure that hyperlinks remain full screen, even after the hx save button is pressed

    var top = baja.topWindow();

    top.$ensureFullScreen = top.$ensureFullScreen || function () {
      asyncUtils.waitForTrue(function () {
        return iframe[0].contentWindow.require;
      }, 10000).then(function () {
        iframe[0].contentWindow.require(['nmodule/webEditors/rc/wb/profile/fullScreen'], function () {});
      })["catch"](function (ignore) {}); //if require is not present, ignore any errors
    };

    this.jq().append(iframe);
  };
  /**
   * PageView for MobileHxPxView
   * @class
   * @memberOf niagara.px
   * @extends  module:mobile/util/mobile/views/PageView
   * @private
   */


  MobileHxPxPageView = baja.subclass(function MobileHxPxPageView() {
    baja.callSuper(MobileHxPxPageView, this, arguments);
  }, PageView);

  MobileHxPxPageView.prototype.instantiateContentView = function () {
    return new MobileHxPxView();
  };

  MobileHxPxPageView.prototype.createPage = function () {
    var page = baja.callSuper('createPage', MobileHxPxPageView, this, arguments),
        headerDiv = page.children(':jqmData(role=header)');
    page.addClass("MobileHxPxView");
    headerDiv.append(commands.getCommandsButton());
    return page;
  };

  MobileHxPxPageViewManager = function MobileHxPxPageViewManager() {
    PageViewManager.call(this);
  };

  MobileHxPxPageViewManager.prototype = new PageViewManager();

  MobileHxPxPageViewManager.prototype.instantiateView = function instantiateView(component, pageData) {
    return Promise.resolve(new MobileHxPxPageView());
  };

  MobileHxPxPageViewManager.prototype.registerPages = function registerPages() {
    pages.register(function ordMatch(str) {
      if (window.niagara.env.type === "hxPx") {
        return str.match(/^ord/);
      }

      return false;
    }, this.createPagesHandlers());
  };
  /**
   * Registers Pages handlers and instigates a page change to display the
   * current `HxPx` view. Will be called upon `baja.start`.
   *
   * @name niagara.desktop.initializeUI
   * @function
   * @private
   */


  function initializeUI() {
    appsMgr = new MobileHxPxPageViewManager();
    appsMgr.registerPages();

    function showFirstPage() {
      $(document).on('onShowCommands', 'a.commandsButton', function () {
        if (window.niagara.env.type === "hxPx") {
          var value = appsMgr.$selectedView.value();
          views.getViewsCommand().setOrd(value.getNavOrd());
        }
      });
      mobileUtil.linkToOrdInternal(niagara.view.ord, {
        transition: "none",
        changeHash: false
      });
    }

    pages.register({
      pageshow: showFirstPage
    });
  }

  return initializeUI;
});
