/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Layout class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/gx/gxStyles'], function (baja, gxStyles) {
  "use strict";
  /**
   * @class Layout.
   * 
   * This is currently a partial implementation of Niagara's 'bajaui:Layout' Type.
   * 
   * When creating a Simple, always use the 'make' method instead of creating a new Object.
   *
   * @name Layout
   * @extends baja.Simple
   */

  function Layout(x, xUnit, y, yUnit, w, wUnit, h, hUnit, str) {
    var that = this;
    baja.callSuper(Layout, that, arguments);
    that.$x = x;
    that.$xUnit = xUnit;
    that.$y = y;
    that.$yUnit = yUnit;
    that.$w = w;
    that.$wUnit = wUnit;
    that.$h = h;
    that.$hUnit = hUnit;
    that.$str = str;
  }

  baja.subclass(Layout, baja.Simple);
  var layoutCache = {},
      ABS = Layout.ABS = 0,
      PERCENT = Layout.PERCENT = 1,
      PREF = Layout.PREF = 2,
      notCurrentlySupported = "Not currently supported";
  /**
   * Make Layout.
   */

  Layout.make = function (obj) {
    throw new Error(notCurrentlySupported);
  };
  /**
   * Make Layout.
   */


  Layout.prototype.make = function (obj) {
    return Layout.make.apply(Layout, arguments);
  };
  /**
   * Decode Layout from a String.
   *
   * @param {String} str
   * @return {Layout}
   */


  Layout.prototype.decodeFromString = function (str) {
    // If we have a layout simple cached then use it.
    if (layoutCache[str]) {
      return layoutCache[str];
    }

    var res,
        x,
        xUnit,
        y,
        yUnit,
        w = 0,
        wUnit,
        h = 0,
        hUnit,
        layout;
    res = /^(fill)|([^,%]+)(%)?,([^,%]+)(%)?,([^,%]+)(%)?,([^,%]+)(%)?$/.exec(str); // Handle fill

    if (res[1] === "fill") {
      layout = Layout.FILL;
    } else {
      // x
      x = parseFloat(res[2]);
      xUnit = res[3] === "%" ? PERCENT : ABS; // y

      y = parseFloat(res[4]);
      yUnit = res[5] === "%" ? PERCENT : ABS; // width

      if (res[6] === "pref") {
        wUnit = PREF;
      } else {
        w = parseFloat(res[6]);
        wUnit = res[7] === "%" ? PERCENT : ABS;
      } // height


      if (res[8] === "pref") {
        hUnit = PREF;
      } else {
        h = parseFloat(res[8]);
        hUnit = res[9] === "%" ? PERCENT : ABS;
      }

      layout = new Layout(x, xUnit, y, yUnit, w, wUnit, h, hUnit, str);
    } // Cache the decoded result


    layoutCache[str] = layout;
    return layout;
  };
  /**
   * Encode the Layout to a String.
   *
   * @return {String}
   */


  Layout.prototype.encodeToString = function () {
    return this.$str;
  };
  /**
   * Default Layout instance.
   */


  Layout.FILL = Layout.DEFAULT = new Layout(0, ABS, 0, ABS, 100, PERCENT, 100, PERCENT, "fill");
  /**
   * Return the X.
   *
   * @returns {Number}
   */

  Layout.prototype.getX = function () {
    return this.$x;
  };
  /**
   * Return the X Unit.
   *
   * @returns {Number}
   */


  Layout.prototype.getXUnit = function () {
    return this.$xUnit;
  };
  /**
   * Return the Y.
   *
   * @returns {Number}
   */


  Layout.prototype.getY = function () {
    return this.$y;
  };
  /**
   * Return the Y Unit.
   *
   * @returns {Number}
   */


  Layout.prototype.getYUnit = function () {
    return this.$yUnit;
  };
  /**
   * Return the width.
   *
   * @returns {Number}
   */


  Layout.prototype.getWidth = function () {
    return this.$w;
  };
  /**
   * Return the width unit.
   *
   * @returns {Number}
   */


  Layout.prototype.getWidthUnit = function () {
    return this.$wUnit;
  };
  /**
   * Return the height.
   *
   * @returns {Number}
   */


  Layout.prototype.getHeight = function () {
    return this.$h;
  };
  /**
   * Return the height unit.
   *
   * @returns {Number}
   */


  Layout.prototype.getHeightUnit = function () {
    return this.$hUnit;
  };
  /**
   * Updates the given DOM element with the corresponding CSS for the layout.
   *
   * @param dom the DOM element to update.
   */


  Layout.prototype.update = function (dom) {
    return gxStyles.applyLayout(this, dom);
  };

  return Layout;
});
