/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Insets class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/gx/gxStyles'], function (baja, gxStyles) {
  "use strict";

  var notCurrentlySupported = "Not currently supported";
  /**
   * @class Insets.
   * 
   * This is currently a partial implementation of Niagara's 'gx:Insets' Type.
   * 
   * When creating a Simple, always use the 'make' method instead of creating a new Object.
   *
   * @name Insets
   * @extends baja.Simple
   */

  function Insets(top, right, bottom, left, str) {
    baja.callSuper(Insets, this, arguments);
    this.$top = top;
    this.$right = right;
    this.$bottom = bottom;
    this.$left = left;
    this.$str = str;
  }

  baja.subclass(Insets, baja.Simple);
  /**
   * Make Insets.
   */

  Insets.make = function (obj) {
    throw new Error(notCurrentlySupported);
  };
  /**
   * Make Insets.
   */


  Insets.prototype.make = function (obj) {
    return Insets.make.apply(Insets, arguments);
  };
  /**
   * Decode Insets from a String
   *
   * @param {String} str
   * @return {Insets}
   */


  Insets.prototype.decodeFromString = function (str) {
    if (str === "null") {
      return Insets.NULL;
    }

    var res = /^([^ ]+)? ?([^ ]+)? ?([^ ]+)? ?([^ ]+)?/.exec(str),
        top,
        right,
        bottom,
        left;

    if (!res) {
      throw new Error("Error decoding Insets: " + str);
    } // 1 (shortcut for 1 1 1 1)


    if (res[2] === undefined || res[2] === "") {
      top = right = bottom = left = Number(res[1]);
    } // 1 2 (shortcut for 1 2 1 2)
    else if (res[3] === undefined || res[3] === "") {
        top = bottom = Number(res[1]);
        right = left = Number(res[2]);
      } // 1 2 3   (shortcut for 1 2 3 2)
      else if (res[4] === undefined || res[4] === "") {
          top = Number(res[1]);
          right = left = Number(res[2]);
          bottom = Number(res[3]);
        } // 1 2 3 4 (top right bottom left)
        else if (res[5] === undefined || res[5] === "") {
            top = Number(res[1]);
            right = Number(res[2]);
            bottom = Number(res[3]);
            left = Number(res[4]);
          }

    return new Insets(top, right, bottom, left, str);
  };
  /**
   * Encode the Insets to a String
   *
   * @return {String}
   */


  Insets.prototype.encodeToString = function () {
    return this.$str;
  };
  /**
   * Default and NULL Insets instance
   */


  Insets.NULL = Insets.DEFAULT = new Insets(0, 0, 0, 0, "null");
  /**
   * Return the top.
   *
   * @returns {Number}
   */

  Insets.prototype.getTop = function () {
    return this.$top;
  };
  /**
   * Return the right.
   *
   * @returns {Number}
   */


  Insets.prototype.getRight = function () {
    return this.$right;
  };
  /**
   * Return the bottom.
   *
   * @returns {Number}
   */


  Insets.prototype.getBottom = function () {
    return this.$bottom;
  };
  /**
   * Return the left.
   *
   * @returns {Number}
   */


  Insets.prototype.getLeft = function () {
    return this.$left;
  };
  /**
   * Update the DOM's CSS with the padding.
   *
   * @param dom the DOM element to update
   * @param {Number} [excess] the excess to add onto to any padding by default
   * @param {String} [insetsType] what to update in the CSS (defaults to padding)
   */


  Insets.prototype.update = function (dom, excess, insetsType) {
    return gxStyles.applyInsets(this, dom, excess, insetsType);
  };

  return Insets;
});
