/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview PassThrough class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class Pass Through Converter.
   * 
   * A Component that represents a Niagara 'converters:BPassThrough' Type.
   *
   * @name PassThrough
   * @extends Converter
   */

  function PassThrough() {
    baja.callSuper(PassThrough, this, arguments);
  }

  baja.subclass(PassThrough, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Value} `from` if the types are the same; otherwise `to`
   */

  PassThrough.prototype.convert = function (from, to, target) {
    if (from.getType().is(to.getType())) {
      return from;
    } else {
      return to;
    }
  };

  return PassThrough;
});
