/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ObjectToString class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class Object To String Converter.
   * 
   * A Component that represents a Niagara 'converters:ObjectToString' Type.
   *
   * @name ObjectToString
   * @extends Converter
   */

  function ObjectToString() {
    ObjectToString.$super.apply(this, arguments);
  }

  baja.subclass(ObjectToString, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {Promise} promise to be resolved with a string formatted from
   * the given value
   */

  ObjectToString.prototype.convert = function (from, to, target) {
    return this.getFormat().format({
      object: from,
      target: target
    });
  };

  return ObjectToString;
});
