/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IStatusToBrush class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/util.px', 'mobile/px/converters/Converter'], function (baja, pxUtil, Converter) {
  "use strict";

  var getStatusBrush = pxUtil.getStatusBrush;
  /**
   * @class BIStatus To Brush Converter.
   * 
   * A Component that represents a Niagara 'kitPx:BIStatusToBrush' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIStatus like their Java counterparts.
   *
   * @name IStatusToBrush
   * @extends Converter
   */

  function IStatusToBrush() {
    baja.callSuper(IStatusToBrush, this, arguments);
  }

  baja.subclass(IStatusToBrush, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Simple} a `gx:Brush` converted from the given status
   */

  IStatusToBrush.prototype.convert = function (from, to, target) {
    var status = baja.Status.getStatusFromIStatus(from),
        brush = null,
        obj = {
      isForeground: this.getMode().is("foreground")
    };

    if (status.isDisabled()) {
      obj.statusName = "disabled";
      brush = getStatusBrush(obj);
    } else if (status.isFault()) {
      obj.statusName = "fault";
      brush = getStatusBrush(obj);
    } else if (status.isDown()) {
      obj.statusName = "down";
      brush = getStatusBrush(obj);
    } else if (status.isAlarm()) {
      obj.statusName = "alarm";
      brush = getStatusBrush(obj);
    } else if (status.isStale()) {
      obj.statusName = "stale";
      brush = getStatusBrush(obj);
    } else if (status.isOverridden()) {
      obj.statusName = "overridden";
      brush = getStatusBrush(obj);
    }

    if (brush === null) {
      brush = to;
    }

    return brush;
  };

  return IStatusToBrush;
});
