/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview INumericToNumber class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class INumeric To Number Converter.
   * 
   * A Component that represents a Niagara 'converters:BINumericToNumber' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BINumeric like their Java counterparts.
   *
   * @name INumericToNumber
   * @extends Converter
   */

  function INumericToNumber() {
    baja.callSuper(INumericToNumber, this, arguments);
  }

  baja.subclass(INumericToNumber, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {Number} number converted from the value
   */

  INumericToNumber.prototype.convert = function (from, to, target) {
    var val = Number.getNumberFromINumeric(from);
    return to.make(val);
  };

  return INumericToNumber;
});
