/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IEnumToEnum class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class IEnum To Enum Converter.
   * 
   * A Component that represents a Niagara 'converters:BIEnumToEnum' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIEnum like their Java counterparts.
   *
   * @name IEnumToEnum
   * @extends Converter
   */

  function IEnumToEnum() {
    baja.callSuper(IEnumToEnum, this, arguments);
  }

  baja.subclass(IEnumToEnum, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Enum} an enum value retrieved from the converter's 
   * configured range, depending on the enum value read from the
   * converted value
   */

  IEnumToEnum.prototype.convert = function (from, to, target) {
    var val = baja.Enum.getEnumFromIEnum(from);
    return to.getRange().get(val.getOrdinal());
  };

  return IEnumToEnum;
});
