/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview IBooleanToBoolean class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class BIBoolean To Boolean Converter.
   * 
   * A Component that represents a Niagara 'converters:BIBooleanToBoolean' Type.
   * 
   * Please note, this doesn't work properly since BajaScript Components don't have
   * properly implement BIBoolean like their Java counterparts.
   *
   * @name IBooleanToBoolean
   * @extends Converter
   */

  function IBooleanToBoolean() {
    baja.callSuper(IBooleanToBoolean, this, arguments);
  }

  baja.subclass(IBooleanToBoolean, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {Boolean} the boolean value retrieved from the object
   */

  IBooleanToBoolean.prototype.convert = function (from, to, target) {
    return Boolean.getBooleanFromIBoolean(from);
  };

  return IBooleanToBoolean;
});
