/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview FixedSimple class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/converters/Converter'], function (baja, Converter) {
  "use strict";
  /**
   * @class Fixed Simple Converter.
   * 
   * A Component that represents a Niagara 'converters:FixedSimple' Type.
   *
   * @name FixedSimple
   * @extends Converter
   */

  function FixedSimple() {
    baja.callSuper(FixedSimple, this, arguments);
  }

  baja.subclass(FixedSimple, Converter);
  /**
   * Convert the first object to the second object and return the result.
   *
   * @param {baja.Object} from.
   * @param {baja.Object} to.
   * @param {OrdTarget} target.
   * @returns {baja.Simple} the converter's current value.
   */

  FixedSimple.prototype.convert = function (from, to, target) {
    return this.getValue();
  };

  return FixedSimple;
});
