/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview Include this file to register all available Px Bindings on
 * their corresponding Baja types via baja.registerType().
 * 
 * @author Logan Byam
 * @version 0.0.2.0
 */
define(['baja!', 'baja!kitPx:ActionBinding,bajaui:Binding,kitPx:BoundLabelBinding,' + 'kitPx:IncrementSetPointBinding,kitPx:MomentaryToggleBinding,' + 'kitPx:PopupBinding,kitPx:SetPointBinding,kitPx:SpectrumBinding,' + 'kitPx:SpectrumSetpointBinding,bajaui:ValueBinding,' + 'workbench:WbFieldEditorBinding', 'underscore', 'mobile/px/bindings/ActionBinding', 'mobile/px/bindings/Binding', 'mobile/px/bindings/BoundLabelBinding', 'mobile/px/bindings/IncrementSetPointBinding', 'mobile/px/bindings/PopupBinding', 'mobile/px/bindings/MomentaryToggleBinding', 'mobile/px/bindings/SetPointBinding', 'mobile/px/bindings/SpectrumBinding', 'mobile/px/bindings/SpectrumSetpointBinding', 'mobile/px/bindings/ValueBinding', 'mobile/px/bindings/WbFieldEditorBinding'], function (baja, types, _, ActionBinding, Binding, BoundLabelBinding, IncrementSetPointBinding, PopupBinding, MomentaryToggleBinding, SetPointBinding, SpectrumBinding, SpectrumSetpointBinding, ValueBinding, WbFieldEditorBinding) {
  "use strict";

  return function registerBindings() {
    _.each({
      'kitPx:ActionBinding': ActionBinding,
      'bajaui:Binding': Binding,
      'kitPx:BoundLabelBinding': BoundLabelBinding,
      'kitPx:IncrementSetPointBinding': IncrementSetPointBinding,
      'kitPx:MomentaryToggleBinding': MomentaryToggleBinding,
      'kitPx:PopupBinding': PopupBinding,
      'kitPx:SetPointBinding': SetPointBinding,
      'kitPx:SpectrumBinding': SpectrumBinding,
      'kitPx:SpectrumSetpointBinding': SpectrumSetpointBinding,
      'bajaui:ValueBinding': ValueBinding,
      'workbench:WbFieldEditorBinding': WbFieldEditorBinding
    }, function (ctor, typeSpec) {
      return baja.registerType(typeSpec, function () {
        return ctor;
      });
    });
  };
});
