/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ValueBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'Promise', 'underscore', 'mobile/util/slot', 'mobile/fieldeditors/fieldeditors.dialogs', 'mobile/px/util.px.mobile', 'mobile/px/bindings/Binding'], function (baja, Promise, _, slotUtil, feDialogs, pxUtilMobile, Binding) {
  "use strict";

  var isFireable = slotUtil.isFireable,
      hyperlink = pxUtilMobile.hyperlink,
      callSuper = baja.callSuper;
  /**
   * @class ValueBinding.
   * 
   * A Component that represents a Niagara 'bajaui:ValueBinding' Type.
   *
   * @name ValueBinding
   * @extends Binding
   */

  function ValueBinding() {
    callSuper(ValueBinding, this, arguments);
  }

  baja.subclass(ValueBinding, Binding);
  /**
   * Return true if the Property is overridden.
   *
   * @param {baja.Property} prop the Property to test.
   * @return {Boolean} return true if the Property is overridden.
   */

  ValueBinding.prototype.isOverridden = function (prop) {
    var override = this.get(prop); // If we have a converter then the Property is overriden

    return override !== null && override.getType().is("baja:Converter");
  };
  /**
   * Return any override display String for the given Property.
   *
   * @param {baja.Property} the Widget's Property to return the overridden value for.
   * @return {String} the overridden value
   */


  ValueBinding.prototype.getOnWidget = function (prop) {
    var override = this.get(prop);

    if (override !== null && override.getType().is("baja:Converter")) {
      return override.getConvertedValue();
    }

    return override;
  };
  /**
   * Called when the binding is updated.
   */


  ValueBinding.prototype.update = function () {
    var that = this,
        widget = that.getWidget(),
        converters = that.getSlots().is("baja:Converter").toValueArray(),
        updates = _.map(converters, function (converter) {
      return converter.update(that.$target.getObject(), widget.getSlot(converter.getName()).getDefaultValue(), that.$target);
    });

    return Promise.all(updates).then(function () {
      return callSuper("update", ValueBinding, that);
    });
  };
  /**
   * Called when the binding is first loaded.
   */


  ValueBinding.prototype.doLoad = function () {
    if (this.getHyperlink() !== baja.Ord.DEFAULT) {
      this.getWidget().addMouseOver();
    }
  };
  /**
   * Handle an event from the Widget.
   *
   * @param {String} eventName.
   * @return {Boolean} return true if this binding has handled the event.
   */


  ValueBinding.prototype.handleEvent = function (eventName) {
    if (eventName !== "click") {
      return false;
    } // If specified, then let the hyperlink take precedence


    if (this.getHyperlink() !== baja.Ord.DEFAULT) {
      // Hyperlink
      return hyperlink(this.getWidget(), this.getHyperlink());
    } // Action pop up


    if (this.isBound() && this.getPopupEnabled()) {
      var comp = this.$target.getComponent();

      if (comp) {
        var hasActions = false;
        comp.getSlots(function (slot) {
          return isFireable(slot);
        }).each(function (slot) {
          hasActions = true;
          return true;
        });

        if (hasActions) {
          // Show available Actions
          feDialogs.showAvailableActions(comp);
          return true;
        }
      }
    }

    return false;
  };

  return ValueBinding;
});
