/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview SpectrumSetpointBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'Promise', 'underscore', 'mobile/px/bindings/ValueBinding', 'mobile/px/bindings/SpectrumBinding'], function (baja, Promise, _, ValueBinding, SpectrumBinding) {
  "use strict";

  var callSuper = baja.callSuper;
  /**
   * @class SpectrumSetpointBinding.
   * 
   * A Component that represents a Niagara 'kitPx:SpectrumSetpointBinding' Type.
   *
   * @name SpectrumSetpointBinding
   * @extends ValueBinding
   */

  function SpectrumSetpointBinding() {
    callSuper(SpectrumSetpointBinding, this, arguments);
  }

  baja.subclass(SpectrumSetpointBinding, ValueBinding);
  /**
   * Called when the binding is updated.
   */

  SpectrumSetpointBinding.prototype.update = function () {
    var prom;

    if (this.isBound()) {
      var targetVal = this.$target.getObject();

      if (targetVal.getType().is("baja:INumeric")) {
        // Find all SpectrumBindings and update the setpoint Property
        // with the corresponding Property
        var newVal = Number.getNumberFromINumeric(targetVal);

        var widget = this.getWidget(),
            bindings = widget.getSlots().is('kitPx:SpectrumBinding').toValueArray(),
            updates = _.map(bindings, function (binding) {
          binding.setSetpoint(newVal);
          return binding.update();
        });

        prom = Promise.all(updates);
      }
    }

    return Promise.join(prom, callSuper("update", SpectrumBinding, this, arguments));
  };

  return SpectrumSetpointBinding;
});
