/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview PopupBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/px/util.px.mobile', 'mobile/px/bindings/Binding'], function (baja, pxUtilMobile, Binding) {
  "use strict";

  var hyperlink = pxUtilMobile.hyperlink;
  /**
   * @class PopupBinding.
   * 
   * A Component that represents a Niagara 'kitPx:PopupBinding' Type.
   *
   * @name PopupBinding
   * @extends Binding
   */

  function PopupBinding() {
    baja.callSuper(PopupBinding, this, arguments);
  }

  baja.subclass(PopupBinding, Binding);
  /**
   * Handle an event from the Widget.
   *
   * @param {String} eventName.
   * @return {Boolean} return true if this binding has handled the event.
   */

  PopupBinding.prototype.handleEvent = function (eventName) {
    if (eventName === "click") {
      var ord = this.getOrd();

      if (ord !== baja.Ord.DEFAULT) {
        return hyperlink(this.getWidget(), ord);
      }
    }

    return false;
  };
  /**
   * Called when the binding is first loaded.
   */


  PopupBinding.prototype.doLoad = function () {
    if (this.getOrd() !== baja.Ord.DEFAULT) {
      this.getWidget().addMouseOver();
    }
  };

  return PopupBinding;
});
