/**
 * @license Copyright 2012, Tridium, Inc. All Rights Reserved.
 */

/**
 * @fileOverview ActionBinding class
 * 
 * @author Gareth Johnson
 * @version 0.0.2.0
 */
define(['baja!', 'mobile/fieldeditors/fieldeditors.dialogs', 'mobile/px/bindings/Binding'], function (baja, feDialogs, Binding) {
  "use strict";
  /**
   * @class ActionBinding.
   * 
   * A Component that represents a Niagara 'kitPx:ActionBinding' Type.
   *
   * @name ActionBinding
   * @extends Binding
   */

  function ActionBinding() {
    baja.callSuper(ActionBinding, this, arguments);
  }

  baja.subclass(ActionBinding, Binding);
  /**
   * Handle an event from the Widget.
   *
   * @param {String} eventName.
   * @return {Boolean} return true if this binding has handled the event.
   */

  ActionBinding.prototype.handleEvent = function (eventName) {
    var target = this.$target;

    if (!this.isBound() || this.getWidgetEvent() !== "actionPerformed") {
      return false;
    }

    if (!(target.slot && target.slot.isAction())) {
      throw new Error("ActionBinding not bound to Action");
    }

    feDialogs.action({
      component: target.getComponent(),
      slot: target.slot,
      parameter: this.getActionArg()
    });
    return true;
  };

  return ActionBinding;
});
