/**
 * @copyright 2015 Tridium, Inc. All Rights Reserved.
 * @author Scott Hoye
 * @since Niagara 4.0
 */

/*jshint browser:true */

/**
 * API Status: **Private**
 * @module nmodule/search/rc/DefaultSearchResultsCompactWidget
 */
define(['bajaux/Widget',
        'bajaux/mixin/subscriberMixIn',
        'jquery',
        'nmodule/search/rc/DefaultSearchResultsWidget',
        'nmodule/webEditors/rc/fe/feDialogs',
        'hbs!nmodule/search/rc/template/DefaultSearchResultsCompactWidget-expandAll',
        'hbs!nmodule/search/rc/template/DefaultSearchResultsCompactWidget-result',
        'baja!',
        'lex!search',
        'css!nmodule/search/rc/DefaultSearchResultsCompactWidget'], function (
        Widget,
        subscriberMixin,
        $,
        DefaultSearchResultsWidget,
        feDialogs,
        tplExpandAll,
        tplResult,
        baja,
        lexs) {

  'use strict';

  var lex = lexs[0],
      RESULT_CLASS = '.n4-search-widget-result',
      ORD_CLASS = '.n4-search-widget-ord',
      EXPAND_ALL_CONTAINER_CLASS = '.n4-search-widget-compact-expandAll-container',
      EXPAND_ALL_CLASS = '.n4-search-widget-expandAll-button',
      COLLAPSE_ALL_CLASS = '.n4-search-widget-collapseAll-button',
      EXPAND_IMAGE = '/module/icons/x16/expand.png',
      COLLAPSE_IMAGE = '/module/icons/x16/collapse.png',
      EXPAND_CLASS = '.n4-search-widget-expand-button',
      ORD_ROW_CLASS = '.n4-search-widget-ord-row',
      VALUE_ROW_CLASS = '.n4-search-widget-value-row',
      SHORT_VALUE_CLASS = '.n4-search-widget-value-short',
      EXPAND_ALL_TXT = lex.get('SearchWidget.commands.expandAll'),
      COLLAPSE_ALL_TXT = lex.get('SearchWidget.commands.collapseAll'),
      EXPANDED_ROW_CLASS = 'expanded';

  /**
   * The Default Search Results Compact Widget.
   *
   * @class
   * @extends module:nmodule/search/rc/DefaultSearchResultsWidget
   * @alias module:nmodule/search/rc/DefaultSearchResultsCompactWidget
   */
  var DefaultSearchResultsCompactWidget = function DefaultSearchResultsCompactWidget() {
    /** remember to call super constructor. Javascript won't do this for you */
    DefaultSearchResultsWidget.apply(this, arguments);
    subscriberMixin(this);
  };

  //extend and set up prototype chain
  DefaultSearchResultsCompactWidget.prototype = Object.create(DefaultSearchResultsWidget.prototype);
  DefaultSearchResultsCompactWidget.prototype.constructor = DefaultSearchResultsCompactWidget;

  /**
   * Do initial setup of the DOM for the Widget. This will set up the DOM's
   * structure and create a space where the commands and table will go.
   *
   * @param {jQuery} element the DOM element into which to load this Widget
   */
  DefaultSearchResultsCompactWidget.prototype.doInitialize = function (dom) {
    var parentDom = dom.parent();

    // Add the 'Expand All' and 'Collapse All' buttons
    parentDom.find('.n4-search-widget-compact-summary').first().append(tplExpandAll({
      expandAllText: EXPAND_ALL_TXT,
      collapseAllText: COLLAPSE_ALL_TXT
    }));

    // Initially we should hide the expand/collapse all buttons until we have displayed results
    parentDom.find(EXPAND_ALL_CONTAINER_CLASS).first().hide();

    // Expand All button handler
    parentDom.on('click', EXPAND_ALL_CLASS, function () {
      var ordRows = dom.find(ORD_ROW_CLASS),
          valueRows = dom.find(VALUE_ROW_CLASS),
          compactValueCells = dom.find(SHORT_VALUE_CLASS),
          buttonImages = dom.find(EXPAND_CLASS).children('img');

      if (ordRows) {
        ordRows.addClass(EXPANDED_ROW_CLASS);
      }

      if (valueRows) {
        valueRows.addClass(EXPANDED_ROW_CLASS);
      }

      if (compactValueCells) {
        compactValueCells.addClass(EXPANDED_ROW_CLASS);
      }

      if (buttonImages) {
        buttonImages.attr('src', COLLAPSE_IMAGE);
      }
    });

    // Collapse All button handler
    parentDom.on('click', COLLAPSE_ALL_CLASS, function () {
      var ordRows = dom.find(ORD_ROW_CLASS),
          valueRows = dom.find(VALUE_ROW_CLASS),
          compactValueCells = dom.find(SHORT_VALUE_CLASS),
          buttonImages = dom.find(EXPAND_CLASS).children('img');

      if (ordRows) {
        ordRows.removeClass(EXPANDED_ROW_CLASS);
      }

      if (valueRows) {
        valueRows.removeClass(EXPANDED_ROW_CLASS);
      }

      if (compactValueCells) {
        compactValueCells.removeClass(EXPANDED_ROW_CLASS);
      }

      if (buttonImages) {
        buttonImages.attr('src', EXPAND_IMAGE);
      }
    });

    // Expand button handler
    dom.on('click', EXPAND_CLASS, function () {
      var button = $(this),
          ord = button.data('ord'),
          img = button.children('img'),
          ordSelector = '[data-ord=\'' + ord + '\']',
          ordRow = dom.find(ORD_ROW_CLASS).filter(ordSelector),
          valueRow = dom.find(VALUE_ROW_CLASS).filter(ordSelector),
          compactValueCell = dom.find(SHORT_VALUE_CLASS).filter(ordSelector);

      if (ordRow) {
        ordRow.toggleClass(EXPANDED_ROW_CLASS);
      }

      if (valueRow) {
        valueRow.toggleClass(EXPANDED_ROW_CLASS);
      }

      if (compactValueCell) {
        compactValueCell.toggleClass(EXPANDED_ROW_CLASS);
      }

      if (img.attr('src') === EXPAND_IMAGE) {
        img.attr('src', COLLAPSE_IMAGE);
      } else {
        img.attr('src', EXPAND_IMAGE);
      }
    });

    // Supply a tool tip containing the nav ORD on search result rows,
    // but only show it when the result row is in a collapsed state
    dom.on('mouseenter', RESULT_CLASS, function () {
      var resultRow = $(this),
          ordRow = resultRow.find(ORD_ROW_CLASS).first(),
          navOrd;

      if (ordRow) {
        if (!ordRow.hasClass(EXPANDED_ROW_CLASS)) {
          navOrd = ordRow.find(ORD_CLASS).first();
          if (navOrd) {
            navOrd = navOrd.text();
            if (navOrd) {
              resultRow.attr('title', navOrd);
              return;
            }
          }
        }
      }
      resultRow.removeAttr('title');
    });

    this.initializeCommonSearchElements(dom);
  };

  /**
   * Returns the number of search results currently displayed for the current page
   * in view
   */
  DefaultSearchResultsCompactWidget.prototype.getDisplayedResultsCount = function () {
    // Overridden here so that we can show/hide the expand/collapse all buttons
    // based on whether there are any results displayed
    var displayedResults = DefaultSearchResultsWidget.prototype.getDisplayedResultsCount.call(this),
        expandAllContainer = this.jq().parent().find(EXPAND_ALL_CONTAINER_CLASS).first();

    if (displayedResults > 0) {
      expandAllContainer.show();
    } else {
      expandAllContainer.hide();
    }

    return displayedResults;
  };

  /**
   * Returns the handlebars template to use for a search result
   */
  DefaultSearchResultsCompactWidget.prototype.getResultTemplate = function () {
    return tplResult;
  };

  return DefaultSearchResultsCompactWidget;
});
