/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.io.ByteArrayInputStream;
import java.util.TimeZone;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.test.Test;

public class IOTest
extends Test {
    @Override
    public void run() throws Exception {
        this.verify(new Obj());
        this.verify(new Obj("foo"));
        this.verify(new Bool());
        this.verify(new Bool("foo"));
        this.verify(new Bool(true));
        this.verify(new Bool("foo", false));
        this.verify(new Enum());
        this.verify(new Enum("foo", ""));
        this.verify(new Enum("foo", "bar"));
        this.verify(new Int());
        this.verify(new Int("foo"));
        this.verify(new Int(77L));
        this.verify(new Int("foo", 77L));
        this.verify(new Int("foo", 5124095577148911L));
        this.verify(new Real());
        this.verify(new Real("foo"));
        this.verify(new Real(1.7));
        this.verify(new Real("foo", 1.7));
        this.verify(new Str());
        this.verify(new Str("foo", ""));
        this.verify(new Str("foo", "hello world"));
        this.verify(new Abstime());
        this.verify(new Abstime("foo"));
        this.verify(new Abstime("foo", System.currentTimeMillis()));
        this.verify(new Reltime());
        this.verify(new Reltime("foo"));
        this.verify(new Reltime("foo", 60000L));
        this.verify(new Time());
        this.verify(new Time("foo"));
        this.verify(new Time(23, 59, 0));
        this.verify(new Time("foo", 1, 2, 3, 4));
        this.verify(new Date());
        this.verify(new Date("foo"));
        this.verify(new Date(2011, 3, 30));
        this.verify(new Date("foo", 1929, 12, 31));
        this.verify(new Uri());
        this.verify(new Uri("foo", ""));
        this.verify(new Uri("foo", "obix:foo"));
        this.verify(new Op());
        this.verify(new Op("foo"));
        this.verify(new Op("foo", new Contract("obix:Foo"), new Contract("obix:Bar")));
        this.verify(new Op("foo", new Contract("obix:Foo obix:Ray"), new Contract("obix:Bar obix:Boo")));
        this.verify(new Feed());
        this.verify(new Feed("foo"));
        this.verify(new Feed("foo", new Contract("obix:Foo"), null));
        this.verify(new Feed("foo", null, new Contract("obix:Bar")));
        this.verify(new Feed("foo", new Contract("obix:Foo"), new Contract("obix:Bar")));
        this.verify(new Ref());
        this.verify(new Ref("foo"));
        this.verify(new Ref("foo", new Uri("/obix/foo")));
        this.verify(new Err());
        this.verify(new Err("foo"));
        Obj x = new Obj();
        x.setHref(new Uri("/obix/boo"));
        this.verify(x);
        x = new Obj();
        x.setIs(new Contract("/obix/boo obix:Hanover"));
        this.verify(x);
        this.verify(new List());
        this.verify(new List("coolList"));
        this.verify(new List("coolList", new Contract("obix:Uri")));
        x = new Obj();
        x.add(new Obj("foo"));
        x.add(new Int("bar", 1972L));
        x.add(new Real("moo", 0.5));
        x.add(new Str("description", "Pretty cool"));
        x.add(new List("items", new Contract("obix:Str")));
        x.add(new Op("doIt", new Contract("obix:Str"), new Contract("obix:Int")));
        x.add(new Feed("yourFired", new Contract("obix:Nil"), new Contract("obix:Int")));
        Obj nest = new Obj("nest");
        x.add(nest);
        nest.add(new Int("baz", -33L));
        this.verify(x);
        x = new Obj();
        x.setDisplay("da display");
        this.verify(x);
        x = new Obj();
        x.setDisplayName("da displayName");
        this.verify(x);
        x = new Obj();
        x.setNull(true);
        this.verify(x);
        x = new Obj();
        x.setIcon(new Uri("/icon.png"));
        this.verify(x);
        x = new Obj();
        x.setWritable(true);
        this.verify(x);
        x = new Obj();
        for (int i = 0; i < Status.list().length; ++i) {
            x.setStatus(Status.list()[i]);
            this.verify(x);
        }
        Bool b = new Bool();
        b.setRange(new Uri("/myrange"));
        this.verify(b);
        Int i = new Int();
        i.setMin(0L);
        this.verify(i);
        i = new Int();
        i.setMax(88L);
        this.verify(i);
        i = new Int();
        i.setUnit(new Uri("obix:Celsius"));
        this.verify(i);
        Real r = new Real();
        r.setMin(0.0);
        this.verify(r);
        r = new Real();
        r.setMax(88.0);
        this.verify(r);
        r = new Real();
        r.setUnit(new Uri("obix:Celsius"));
        this.verify(r);
        r = new Real();
        r.setPrecision(3);
        this.verify(r);
        Enum e = new Enum();
        e.setRange(new Uri("/myrange"));
        this.verify(e);
        Str s = new Str();
        s.setMin(1);
        this.verify(s);
        s = new Str();
        s.setMax(20);
        this.verify(s);
        Reltime rt = new Reltime();
        rt.setMin(new Reltime(99L));
        this.verify(rt);
        rt = new Reltime();
        rt.setMax(new Reltime(-8L));
        this.verify(rt);
        Abstime a = new Abstime();
        a.setMin(new Abstime(System.currentTimeMillis()));
        this.verify(a);
        a = new Abstime();
        a.setMax(new Abstime(System.currentTimeMillis()));
        this.verify(a);
        TimeZone tz = TimeZone.getTimeZone("Europe/London");
        a = new Abstime(System.currentTimeMillis(), tz);
        this.verify(a);
        Time time = new Time();
        time.setMin(new Time(0, 0, 0));
        this.verify(time);
        time = new Time();
        time.setMax(new Time(23, 59, 59, 999));
        this.verify(time);
        time = new Time(3, 45, 9);
        time.setTz("America/Chicago");
        this.verify(time);
        Date date = new Date();
        date.setMin(new Date(1980, 1, 1));
        this.verify(date);
        date = new Date();
        date.setMax(new Date(2020, 12, 31));
        this.verify(date);
        date = new Date(2003, 6, 3);
        date.setTz("America/Denver");
        this.verify(date);
        List l = new List();
        l.setMin(1);
        this.verify(l);
        l = new List();
        l.setMax(20);
        this.verify(l);
        Obj obj = this.make("<obj><what/><int name='i' val='3'/></obj>");
        this.verify(obj.size() == 1);
        this.verify(obj.get("i").getInt() == 3L);
        x = new Obj();
        x.setIs(new Contract("acme:FooBar"));
        x.add(new Str("a", "a"));
        x.add(new Str("b", "beta"));
        x.add(new Str("c0", "charlie really long string"));
        x.add(new Str("c1", "charlie really long string"));
        x.add(new Str("c2", "charlie really long string"));
        nest = new Obj("nest");
        x.add(nest);
        nest.setIs(new Contract("acme:FooBar"));
        nest.add(new Str("a", "a"));
        nest.add(new Str("b", "beta"));
        nest.add(new Str("xyz", "xyz"));
        this.verify(x);
        this.verifySingleStr("acme:FooBar", this.binaryRoundtrip);
        this.verifySingleStr("beta", this.binaryRoundtrip);
        this.verifySingleStr("xyz", this.binaryRoundtrip);
        this.verifySingleStr("charlie really long string", this.binaryRoundtrip);
    }

    public void verify(Obj orig) throws Exception {
        this.roundtrip(orig);
    }

    public Obj make(String xml) throws Exception {
        return this.make(xml, true);
    }

    public Obj make(String xml, boolean useContracts) throws Exception {
        ObixDecoder decoder = ObixDecoder.make(new ByteArrayInputStream(xml.getBytes()));
        decoder.setUseContracts(useContracts);
        return decoder.decodeDocument();
    }

    void verifySingleStr(String s, byte[] binary) {
        int match = -1;
        for (int i = 0; i < binary.length; ++i) {
            if (!IOTest.match(s, binary, i)) continue;
            if (match < 0) {
                match = i;
                continue;
            }
            throw new RuntimeException("Multiple matches for string '" + s + "'");
        }
        this.verify(match >= 0);
    }

    static boolean match(String s, byte[] buf, int off) {
        for (int i = 0; i < s.length(); ++i) {
            if (i + off >= buf.length) {
                return false;
            }
            if (buf[off + i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

