/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Date;
import obix.test.Test;

public class DateTest
extends Test {
    @Override
    public void run() throws Exception {
        Date d = new Date(2009, 10, 21);
        this.verify(d.getYear(), 2009L);
        this.verify(d.getMonth(), 10L);
        this.verify(d.getDay(), 21L);
        this.verify(d.equals(new Date(2009, 10, 21)));
        this.verify(!d.equals(new Date(2009, 10, 22)));
        this.verify(!d.equals(new Date(2009, 11, 21)));
        this.verify(!d.equals(new Date(2010, 10, 21)));
        this.verify(new Date(2009, 2, 3).compareTo(new Date(2009, 2, 3)) == 0);
        this.verify(new Date(2008, 2, 3).compareTo(new Date(2009, 2, 3)) < 0);
        this.verify(new Date(2019, 2, 3).compareTo(new Date(2009, 2, 3)) > 0);
        this.verify(new Date(2009, 12, 3).compareTo(new Date(2009, 2, 3)) > 0);
        this.verify(new Date(2009, 2, 3).compareTo(new Date(2009, 2, 8)) < 0);
        this.verify("2009-10-21", 2009, 10, 21);
        this.verify("2000-01-02", 2000, 1, 2);
        this.verify("1972-06-30", 1972, 6, 30);
        this.verifyInvalid("2009-10-2");
        this.verifyInvalid("2009-1-21");
        this.verifyInvalid("2009.10-21");
        this.verifyInvalid("2009-10.21");
    }

    public void verify(String s, int year, int mon, int day) throws Exception {
        Date d = new Date();
        d.decodeVal(s);
        this.verify(d.getYear() == year);
        this.verify(d.getMonth() == mon);
        this.verify(d.getDay() == day);
        this.verify(d, new Date(year, mon, day));
        Date x = new Date();
        x.decodeVal(d.encodeVal());
        this.verify(x, d);
    }

    public void verifyInvalid(String s) throws Exception {
        Exception ex = null;
        Date t = new Date();
        try {
            t.decodeVal(s);
        }
        catch (Exception e) {
            ex = e;
        }
        this.verify(ex != null);
    }
}

