/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import java.io.ByteArrayInputStream;
import obix.Abstime;
import obix.Contract;
import obix.Enum;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Real;
import obix.Ref;
import obix.Str;
import obix.contracts.About;
import obix.contracts.AckAlarm;
import obix.contracts.Alarm;
import obix.contracts.Dimension;
import obix.contracts.History;
import obix.contracts.Lobby;
import obix.contracts.Point;
import obix.contracts.PointAlarm;
import obix.contracts.Unit;
import obix.contracts.WritablePoint;
import obix.io.ObixDecoder;
import obix.test.Test;

public class ContractTest
extends Test {
    @Override
    public void run() throws Exception {
        this.verify(!(this.make("<obj is='obix:Point'/>", false) instanceof Point));
        this.verify(!(this.make("<obj is='obix:History obix:Point'/>", false) instanceof Point));
        this.verify(!(this.make("<obj is='obix:History obix:Point'/>", false) instanceof History));
        this.verify(!(this.make("<real is='obix:History obix:Point'/>", false) instanceof History));
        this.verify(this.make("<real is='obix:History obix:Point'/>", false) instanceof Real);
        this.verify(this.make("<obj is='obix:Point'/>") instanceof Point);
        this.verify(this.make("<obj is='obix:Point'/>") instanceof Obj);
        this.verify(this.make("<obj is='obix:Point'/>").getClass().getSuperclass() == Obj.class);
        this.verify(this.make("<real is='obix:Point'/>") instanceof Point);
        this.verify(this.make("<real is='obix:Point'/>") instanceof Obj);
        this.verify(this.make("<real is='obix:Point'/>") instanceof Real);
        this.verify(this.make("<int  is='obix:Point'/>").getClass().getSuperclass() == Int.class);
        Dimension dim = (Dimension)((Object)this.make("<obj is='obix:Dimension'/>"));
        this.verify(dim.getClass().getSuperclass() == Obj.class);
        this.verify(dim.size() == 7);
        this.verify(dim.kg().get() == 0L);
        this.verify(dim.kg().getClass() == Int.class);
        this.verify(dim.m().get() == 0L);
        this.verify(dim.sec().get() == 0L);
        this.verify(dim.K().get() == 0L);
        this.verify(dim.A().get() == 0L);
        this.verify(dim.mol().get() == 0L);
        this.verify(dim.cd().get() == 0L);
        dim.m().set(1L);
        dim.sec().set(-2L);
        dim = (Dimension)((Object)this.roundtrip((Obj)((Object)dim), false));
        this.verify(dim.m().get() == 1L);
        this.verify(dim.sec().get() == -2L);
        Unit unit = (Unit)((Object)this.make("<obj is='obix:Unit'/>"));
        this.verify(unit.getClass().getSuperclass() == Obj.class);
        this.verify(unit.size() == 4);
        this.verify(unit.symbol().get().equals(""));
        this.verify(unit.offset().get() == 0.0);
        this.verify(unit.scale().get() == 1.0);
        this.verify(unit.dimension() instanceof Dimension);
        this.verify(unit.dimension() instanceof Obj);
        this.verify(unit.dimension().getIs().toString().equals("obix:Dimension"));
        unit = (Unit)((Object)this.make("<obj is='obix:Unit'><str name='symbol' val='\u00baC'/><obj name='dimension'><int name='K' val='1'/></obj><real name='offset' val='273'/></obj>"));
        this.verify(unit.symbol().get().equals("\u00baC"));
        this.verify(unit.offset().get() == 273.0);
        this.verify(unit.scale().get() == 1.0);
        this.verify(unit.dimension().K().get() == 1L);
        this.verify(unit.dimension().kg().get() == 0L);
        unit.dimension().K().set(2L);
        unit.dimension().kg().set(-8L);
        unit.scale().set(77.0);
        unit = (Unit)((Object)this.roundtrip((Obj)((Object)unit), false));
        this.verify(unit.symbol().get().equals("\u00baC"));
        this.verify(unit.offset().get() == 273.0);
        this.verify(unit.scale().get() == 77.0);
        this.verify(unit.dimension().K().get() == 2L);
        this.verify(unit.dimension().kg().get() == -8L);
        unit = (Unit)((Object)this.make("<str is='obix:Unit' val='just messing with you'/>"));
        this.verify(unit.getClass().getSuperclass() == Str.class);
        this.verify(unit.getStr().equals("just messing with you"));
        History history = (History)((Object)this.make("<obj is='obix:History'/>"));
        this.verify(history.count().getMin() == 0L);
        WritablePoint wpt = (WritablePoint)((Object)this.make("<obj is='obix:WritablePoint'/>"));
        this.verify(wpt.writePoint().getIn(), new Contract("obix:WritePointIn"));
        this.verify(wpt.writePoint().getOut(), new Contract("obix:Point"));
        Enum pt = (Enum)this.make("<enum is='obix:Point obix:History' val='off'/>");
        this.verify(pt.get(), (Object)"off");
        this.verify(pt instanceof Point);
        this.verify(pt instanceof History);
        this.verify(((History)((Object)pt)).count().get(), 0L);
        List list = (List)this.make("<list of='obix:Unit'><obj><str name='symbol' val='xyz'/></obj></list>");
        Obj[] listVals = list.list();
        this.verify(listVals.length == 1);
        this.verify(listVals[0] instanceof Unit);
        this.verify(((Unit)((Object)listVals[0])).symbol().get(), (Object)"xyz");
        list = (List)this.make("<list of='obix:Point'><obj/><int is='obix:Unit obix:Point'/></list>");
        listVals = list.list();
        this.verify(listVals.length == 2);
        this.verify(listVals[0].getClass().getSuperclass(), Obj.class);
        this.verify(listVals[0] instanceof Point);
        this.verify(listVals[1].getClass().getSuperclass(), Int.class);
        this.verify(listVals[1] instanceof Int);
        this.verify(listVals[1] instanceof Point);
        this.verify(listVals[1] instanceof Unit);
        PointAlarm ptAlarm = (PointAlarm)((Object)this.make("<obj is='obix:PointAlarm'><real name='alarmValue' val='-1'/></obj>"));
        this.verify(ptAlarm instanceof Alarm);
        this.verify(ptAlarm.timestamp() instanceof Abstime);
        this.verify(ptAlarm.alarmValue() instanceof Real);
        this.verify(ptAlarm.alarmValue().getReal() == -1.0);
        this.verify(ptAlarm.alarmValue().getName(), (Object)"alarmValue");
        this.verify(ptAlarm.alarmValue().getParent() == ptAlarm);
        Ref ref = (Ref)this.make("<ref is='obix:Point'/>");
        this.verify(ref.getIs(), new Contract("obix:Point"));
        Lobby lobby = (Lobby)((Object)this.make("<obj is='obix:Lobby'/>"));
        this.verify(lobby.about() instanceof Ref);
        this.verify(lobby.about().getIs(), new Contract("obix:About"));
        this.verify(!(lobby.about() instanceof About));
        AckAlarm alarm = (AckAlarm)((Object)this.make("<obj is='obix:AckAlarm'/>"));
        this.verify(alarm.ackTimestamp().isNull());
        this.verify(alarm.ackTimestamp().getMillis() == 0L);
        this.verify(alarm.ackUser().isNull());
        this.verify(alarm.ackUser().get().equals(""));
        alarm = (AckAlarm)((Object)this.make("<obj is='obix:AckAlarm'><abstime name='ackTimestamp' val='2005-09-21T13:14:02.12Z'/><str name='ackUser' val='Fred'/></obj>"));
        this.verify(!alarm.ackTimestamp().isNull());
        this.verify(alarm.ackTimestamp().getMillis() > 0L);
        this.verify(!alarm.ackUser().isNull());
        this.verify(alarm.ackUser().get().equals("Fred"));
        Exception ex = null;
        try {
            this.make("<int is='obix:real'/>");
        }
        catch (Exception e) {
            ex = e;
        }
        this.verify(ex != null);
    }

    public Obj make(String xml) throws Exception {
        return this.make(xml, true);
    }

    public Obj make(String xml, boolean useContracts) throws Exception {
        ObixDecoder decoder = ObixDecoder.make(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        decoder.setUseContracts(useContracts);
        return decoder.decodeDocument();
    }
}

