/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.StringTokenizer;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.ContractRegistry;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.io.ObixDecoder;
import obix.xml.XElem;
import obix.xml.XException;
import obix.xml.XParser;

public class ObixXmlDecoder
extends ObixDecoder {
    private XParser parser;

    public static Obj fromString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes("UTF-8"));
            ObixXmlDecoder decoder = new ObixXmlDecoder(in);
            return decoder.decodeDocument();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public ObixXmlDecoder(InputStream in) throws Exception {
        super(in);
        this.parser = XParser.make(in);
    }

    @Override
    public Obj decode() throws Exception {
        return this.decode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj decode(boolean close) throws Exception {
        try {
            XElem root = this.parser.parse();
            Obj result = this.decode(null, root, null);
            this.warningsForUnresolvedFragRefs();
            Obj obj = result;
            return obj;
        }
        finally {
            if (close) {
                this.parser.close();
            }
        }
    }

    private Obj decode(Obj parent, XElem x, Contract defaultContract) throws Exception {
        XElem[] kids;
        Val r;
        String name = null;
        String val = null;
        String href = null;
        String is = null;
        String of = null;
        String in = null;
        String out = null;
        String display = null;
        String displayName = null;
        String icon = null;
        String isNull = null;
        String writable = null;
        String status = null;
        String range = null;
        String min = null;
        String max = null;
        String unit = null;
        String precision = null;
        String tz = null;
        int attrSize = x.attrSize();
        block46: for (int i = 0; i < attrSize; ++i) {
            String attrName = x.attrName(i);
            String attrVal = x.attrValue(i);
            switch (attrName) {
                case "name": {
                    name = attrVal;
                    continue block46;
                }
                case "val": {
                    val = attrVal;
                    continue block46;
                }
                case "href": {
                    href = attrVal;
                    continue block46;
                }
                case "is": {
                    is = attrVal;
                    continue block46;
                }
                case "of": {
                    of = attrVal;
                    continue block46;
                }
                case "in": {
                    in = attrVal;
                    continue block46;
                }
                case "out": {
                    out = attrVal;
                    continue block46;
                }
                case "display": {
                    display = attrVal;
                    continue block46;
                }
                case "displayName": {
                    displayName = attrVal;
                    continue block46;
                }
                case "null": {
                    isNull = attrVal;
                    continue block46;
                }
                case "icon": {
                    icon = attrVal;
                    continue block46;
                }
                case "writable": {
                    writable = attrVal;
                    continue block46;
                }
                case "status": {
                    status = attrVal;
                    continue block46;
                }
                case "range": {
                    range = attrVal;
                    continue block46;
                }
                case "min": {
                    min = attrVal;
                    continue block46;
                }
                case "max": {
                    max = attrVal;
                    continue block46;
                }
                case "unit": {
                    unit = attrVal;
                    continue block46;
                }
                case "precision": {
                    precision = attrVal;
                    continue block46;
                }
                case "tz": {
                    tz = attrVal;
                }
            }
        }
        String elemName = x.name();
        Class cls = Obj.toClass(elemName);
        if (cls == null) {
            System.out.println("WARNING: Unknown element: " + x + " [Line " + x.line() + "]");
            return null;
        }
        Contract contract = null;
        if (is != null) {
            contract = this.decodeContract(is, x);
        }
        Obj obj = null;
        if (parent != null && name != null) {
            obj = parent.get(name);
        }
        if (obj == null) {
            if (this.getUseContracts()) {
                Contract tempContract = contract;
                Class tempClass = cls;
                cls = AccessController.doPrivileged(() -> {
                    if (tempContract != null) {
                        return ContractRegistry.toClass(tempClass, tempContract);
                    }
                    if (defaultContract != null) {
                        return ContractRegistry.toClass(tempClass, defaultContract);
                    }
                    return tempClass;
                });
            }
            obj = (Obj)cls.newInstance();
        } else if (!elemName.equals(obj.getElement())) {
            if (elemName.equals("ref") || obj.getElement().equals("obj")) {
                Obj newObj = Obj.toObj(elemName);
                if (newObj != null) {
                    newObj.setName(name);
                    if (obj.getParent() != null) {
                        obj.getParent().replace(obj, newObj);
                    }
                    obj = newObj;
                }
            } else {
                throw this.err("Element name '" + elemName + "' conflicts with contract element '" + obj.getElement() + "'", x);
            }
        }
        if (name != null && obj.getName() == null) {
            obj.setName(name);
        }
        if (href != null) {
            if (obj instanceof Ref) {
                obj.setHref(this.decodeRefUri(href, x));
            } else {
                this.decodeHref(obj, href);
            }
        }
        if (contract != null) {
            obj.setIs(contract);
        }
        if (val != null) {
            if (isNull == null) {
                obj.setNull(false);
            }
            try {
                ((Val)obj).decodeVal(val);
            }
            catch (Exception e) {
                throw this.err("Invalid val attribte '" + val + "' for " + obj.getElement(), x, e);
            }
        }
        if (display != null) {
            obj.setDisplay(display);
        }
        if (displayName != null) {
            obj.setDisplayName(displayName);
        }
        if (icon != null) {
            obj.setIcon(new Uri(icon));
        }
        if (status != null) {
            obj.setStatus(Status.parse(status));
        }
        if (isNull != null) {
            obj.setNull(isNull.equals("true"));
        }
        if (writable != null) {
            obj.setWritable(writable.equals("true"));
        }
        Contract childrenDefaultContract = null;
        if (obj instanceof List) {
            List list = (List)obj;
            if (of != null) {
                childrenDefaultContract = this.decodeContract(of, x);
                list.setOf(childrenDefaultContract);
            }
            if (min != null) {
                list.setMin(Integer.parseInt(min));
            }
            if (max != null) {
                list.setMax(Integer.parseInt(max));
            }
        } else if (obj instanceof Op) {
            Op op = (Op)obj;
            if (in != null) {
                op.setIn(this.decodeContract(in, x));
            }
            if (out != null) {
                op.setOut(this.decodeContract(out, x));
            }
        } else if (obj instanceof Bool) {
            Bool b = (Bool)obj;
            if (range != null) {
                b.setRange(this.decodeRefUri(range, x));
            }
        } else if (obj instanceof Int) {
            Int i = (Int)obj;
            if (min != null) {
                i.setMin(Long.parseLong(min));
            }
            if (max != null) {
                i.setMax(Long.parseLong(max));
            }
            if (unit != null) {
                i.setUnit(this.decodeRefUri(unit, x));
            }
        } else if (obj instanceof Str) {
            Str s = (Str)obj;
            if (min != null) {
                s.setMin(Integer.parseInt(min));
            }
            if (max != null) {
                s.setMax(Integer.parseInt(max));
            }
        } else if (obj instanceof Real) {
            r = (Real)obj;
            if (min != null) {
                ((Real)r).setMin(Double.parseDouble(min));
            }
            if (max != null) {
                ((Real)r).setMax(Double.parseDouble(max));
            }
            if (unit != null) {
                ((Real)r).setUnit(this.decodeRefUri(unit, x));
            }
            if (precision != null) {
                ((Real)r).setPrecision(Integer.parseInt(precision));
            }
        } else if (obj instanceof Enum) {
            Enum e = (Enum)obj;
            if (range != null) {
                e.setRange(this.decodeRefUri(range, x));
            }
        } else if (obj instanceof Reltime) {
            r = (Reltime)obj;
            if (min != null) {
                ((Reltime)r).setMin(Reltime.parse(min));
            }
            if (max != null) {
                ((Reltime)r).setMax(Reltime.parse(max));
            }
        } else if (obj instanceof Abstime) {
            Abstime a = (Abstime)obj;
            if (min != null) {
                a.setMin(Abstime.parse(min));
            }
            if (max != null) {
                a.setMax(Abstime.parse(max));
            }
            if (tz != null) {
                a.setTz(tz);
            }
        } else if (obj instanceof Time) {
            Time t = (Time)obj;
            if (min != null) {
                t.setMin(Time.parse(min));
            }
            if (max != null) {
                t.setMax(Time.parse(max));
            }
            if (tz != null) {
                t.setTz(tz);
            }
        } else if (obj instanceof Date) {
            Date d = (Date)obj;
            if (min != null) {
                d.setMin(Date.parse(min));
            }
            if (max != null) {
                d.setMax(Date.parse(max));
            }
            if (tz != null) {
                d.setTz(tz);
            }
        } else if (obj instanceof Feed) {
            Feed feed = (Feed)obj;
            if (in != null) {
                feed.setIn(this.decodeContract(in, x));
            }
            if (of != null) {
                feed.setOf(this.decodeContract(of, x));
            }
        }
        for (XElem kid1 : kids = x.elems()) {
            Obj kid = this.decode(obj, kid1, childrenDefaultContract);
            if (kid == null || kid.getParent() != null) continue;
            try {
                obj.add(kid);
            }
            catch (Exception e) {
                throw this.err("Cannot add child '" + name + "'", kid1, e);
            }
        }
        return obj;
    }

    void decodeHref(Obj obj, String href) {
        Uri uri = new Uri(null, href);
        obj.setHref(uri);
        if (!uri.isFragment()) {
            return;
        }
        this.fragIds.put(href, obj);
        ObixDecoder.FragRefs refs = (ObixDecoder.FragRefs)this.fragRefs.get(href);
        if (refs == null) {
            return;
        }
        this.fragRefs.remove(href);
        for (int i = 0; i < refs.uris.size(); ++i) {
            refs.uris.get(i).setResolved(obj);
        }
    }

    Uri decodeRefUri(String s, XElem elem) {
        Uri uri = new Uri(s);
        if (!uri.isFragment()) {
            return uri;
        }
        Obj resolved = (Obj)this.fragIds.get(s);
        if (resolved != null) {
            uri.setResolved(resolved);
            return uri;
        }
        ObixDecoder.FragRefs refs = (ObixDecoder.FragRefs)this.fragRefs.get(s);
        if (refs == null) {
            refs = new ObixDecoder.FragRefs();
            this.fragRefs.put(s, refs);
        }
        refs.uris.add(uri);
        refs.elems.add(elem);
        return uri;
    }

    Contract decodeContract(String s, XElem elem) {
        StringTokenizer st = new StringTokenizer(s, " ");
        ArrayList<Uri> acc = new ArrayList<Uri>();
        while (st.hasMoreTokens()) {
            acc.add(this.decodeRefUri(st.nextToken(), elem));
        }
        return new Contract(acc.toArray(new Uri[acc.size()]));
    }

    void warningsForUnresolvedFragRefs() {
        ObixDecoder.FragRefs[] unresolved;
        for (ObixDecoder.FragRefs r : unresolved = this.fragRefs.values().toArray(new ObixDecoder.FragRefs[this.fragRefs.size()])) {
            for (int j = 0; j < r.uris.size(); ++j) {
                Uri uri = r.uris.get(j);
                XElem elem = (XElem)r.elems.get(j);
                this.warning("Unresolved fragment reference '" + uri + "'", elem);
            }
        }
    }

    XException err(String msg, XElem elem, Throwable cause) {
        return new XException(msg, elem, cause);
    }

    XException err(String msg, XElem elem) {
        return new XException(msg, elem);
    }

    void warning(String msg, XElem elem) {
        String line = "";
        if (elem != null) {
            line = " [line " + elem.line() + "]";
        }
        System.out.println("WARNING: " + msg + line);
    }
}

