/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Feed;
import obix.Int;
import obix.List;
import obix.Obj;
import obix.Op;
import obix.Real;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.io.ObixEncoder;

public class ObixBinEncoder
extends ObixEncoder {
    private DataOutputStream dout;
    private Map<String, Integer> strTable = new HashMap<String, Integer>();

    public static byte[] toBytes(Obj obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObixBinEncoder encoder = new ObixBinEncoder(out);
            encoder.encode(obj);
            encoder.flush();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public ObixBinEncoder(File file) throws IOException {
        super(file);
        this.dout = new DataOutputStream(this.out);
    }

    public ObixBinEncoder(OutputStream out) throws IOException {
        super(out);
        this.dout = new DataOutputStream(out);
    }

    @Override
    public void encode(Obj obj) throws IOException {
        boolean hasChildren = obj.size() > 0;
        Node node = this.toNode(obj, hasChildren);
        while (node != null) {
            node.write(this.dout);
            node = node.next;
        }
        if (hasChildren) {
            this.dout.write(4);
            Obj[] kids = obj.list();
            for (int i = 0; i < kids.length; ++i) {
                this.encode(kids[i]);
            }
            this.dout.write(68);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public String getContentType() {
        return "application/vnd.tridium.com-obix+binary";
    }

    public void encodeDocument(Obj obj) throws IOException {
        this.strTable.clear();
        this.encode(obj);
        this.flush();
    }

    private Node toNode(Obj obj, boolean markTailMore) {
        Node head = null;
        Node tail = null;
        int objCode = obj.getBinCode();
        switch (objCode) {
            case 4: {
                head = tail = new Node(null, objCode);
                break;
            }
            case 8: {
                Bool b = (Bool)obj;
                head = tail = new BoolNode(null, objCode, b.get());
                if (b.getRange() == null) break;
                tail = new StrNode(tail, 68, b.getRange().toString());
                break;
            }
            case 12: {
                Int i = (Int)obj;
                head = tail = new IntNode(null, objCode, i.get());
                if (i.getMin() != Long.MIN_VALUE) {
                    tail = new IntNode(tail, 52, i.getMin());
                }
                if (i.getMax() != Long.MAX_VALUE) {
                    tail = new IntNode(tail, 56, i.getMax());
                }
                if (i.getUnit() == null) break;
                tail = new StrNode(tail, 60, i.getUnit().toString());
                break;
            }
            case 16: {
                Real f = (Real)obj;
                head = tail = new RealNode(null, objCode, f.get());
                if (f.getMin() != Double.NEGATIVE_INFINITY) {
                    tail = new RealNode(tail, 52, f.getMin());
                }
                if (f.getMax() != Double.POSITIVE_INFINITY) {
                    tail = new RealNode(tail, 56, f.getMax());
                }
                if (f.getUnit() != null) {
                    tail = new StrNode(tail, 60, f.getUnit().toString());
                }
                if (f.getPrecision() == 1) break;
                tail = new IntNode(tail, 64, f.getPrecision());
                break;
            }
            case 20: {
                Str s = (Str)obj;
                head = tail = new StrNode(null, objCode, s.get());
                if (s.getMin() != 0) {
                    tail = new IntNode(tail, 52, s.getMin());
                }
                if (s.getMax() == Integer.MAX_VALUE) break;
                tail = new IntNode(tail, 56, s.getMax());
                break;
            }
            case 24: {
                Enum e = (Enum)obj;
                head = tail = new StrNode(null, objCode, e.get());
                if (e.getRange() == null) break;
                tail = new StrNode(tail, 68, e.getRange().toString());
                break;
            }
            case 32: {
                Abstime a = (Abstime)obj;
                head = tail = new AbstimeNode(null, objCode, a);
                if (a.getMin() != null) {
                    tail = new AbstimeNode(tail, 52, a.getMin());
                }
                if (a.getMax() != null) {
                    tail = new AbstimeNode(tail, 56, a.getMax());
                }
                if (a.getTz() == null) break;
                tail = new StrNode(tail, 72, a.getTz());
                break;
            }
            case 36: {
                Reltime r = (Reltime)obj;
                head = tail = new ReltimeNode(null, objCode, r);
                if (r.getMin() != null) {
                    tail = new ReltimeNode(tail, 52, r.getMin());
                }
                if (r.getMax() == null) break;
                tail = new ReltimeNode(tail, 56, r.getMax());
                break;
            }
            case 44: {
                Time t = (Time)obj;
                head = tail = new TimeNode(null, objCode, t);
                if (t.getMin() != null) {
                    tail = new TimeNode(tail, 52, t.getMin());
                }
                if (t.getMax() != null) {
                    tail = new TimeNode(tail, 56, t.getMax());
                }
                if (t.getTz() == null) break;
                tail = new StrNode(tail, 72, t.getTz());
                break;
            }
            case 40: {
                Date d = (Date)obj;
                head = tail = new DateNode(null, objCode, d);
                if (d.getMin() != null) {
                    tail = new DateNode(tail, 52, d.getMin());
                }
                if (d.getMax() != null) {
                    tail = new DateNode(tail, 56, d.getMax());
                }
                if (d.getTz() == null) break;
                tail = new StrNode(tail, 72, d.getTz());
                break;
            }
            case 28: {
                Uri u = (Uri)obj;
                head = tail = new StrNode(null, objCode, u.get());
                break;
            }
            case 48: {
                List list = (List)obj;
                head = tail = new Node(null, objCode);
                if (!list.getOf().containsOnlyObj()) {
                    tail = new ContractNode(tail, 20, list.getOf());
                }
                if (list.getMin() != 0) {
                    tail = new IntNode(tail, 52, list.getMin());
                }
                if (list.getMax() == Integer.MAX_VALUE) break;
                tail = new IntNode(tail, 56, list.getMax());
                break;
            }
            case 52: {
                Op op = (Op)obj;
                head = tail = new Node(null, objCode);
                if (!op.getIn().containsOnlyObj()) {
                    tail = new ContractNode(tail, 24, op.getIn());
                }
                if (op.getOut().containsOnlyObj()) break;
                tail = new ContractNode(tail, 28, op.getOut());
                break;
            }
            case 56: {
                Feed feed = (Feed)obj;
                head = tail = new Node(null, objCode);
                if (!feed.getIn().containsOnlyObj()) {
                    tail = new ContractNode(tail, 24, feed.getIn());
                }
                if (feed.getOf().containsOnlyObj()) break;
                tail = new ContractNode(tail, 20, feed.getOf());
                break;
            }
            case 60: 
            case 64: {
                head = tail = new Node(null, objCode);
                break;
            }
            default: {
                throw new IllegalStateException(obj.getElement());
            }
        }
        if (obj.getName() != null) {
            tail = new StrNode(tail, 8, obj.getName());
        }
        if (obj.getHref() != null) {
            tail = new StrNode(tail, 12, obj.getHref().encodeVal());
        }
        if (obj.getIs() != null) {
            tail = new ContractNode(tail, 16, obj.getIs());
        }
        if (obj.getStatus() != Status.ok) {
            tail = new StatusNode(tail, 76, obj.getStatus());
        }
        if (obj.getDisplay() != null) {
            tail = new StrNode(tail, 44, obj.getDisplay());
        }
        if (obj.getDisplayName() != null) {
            tail = new StrNode(tail, 40, obj.getDisplayName());
        }
        if (obj.getIcon() != null) {
            tail = new StrNode(tail, 36, obj.getIcon().encodeVal());
        }
        if (obj.isNull()) {
            tail = new BoolNode(tail, 32, true);
        }
        if (obj.isWritable()) {
            tail = new BoolNode(tail, 48, true);
        }
        if (markTailMore) {
            tail.code |= 0x80;
        }
        return head;
    }

    static void writeStr(DataOutputStream out, String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\u0000' || c > '\u007f') {
                throw new IOException("Invalic ASCII string chars: " + s);
            }
            out.write(c);
        }
        out.write(0);
    }

    static class StatusNode
    extends Node {
        Status val;

        StatusNode(Node n, int c, Status v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            int x;
            if (this.val == Status.disabled) {
                x = 76;
            } else if (this.val == Status.fault) {
                x = 77;
            } else if (this.val == Status.down) {
                x = 78;
            } else if (this.val == Status.unackedAlarm) {
                x = 79;
            } else if (this.val == Status.alarm) {
                x = 80;
            } else if (this.val == Status.unacked) {
                x = 81;
            } else if (this.val == Status.overridden) {
                x = 82;
            } else {
                throw new IllegalStateException(this.val.toString());
            }
            out.write(x);
        }
    }

    static class DateNode
    extends Node {
        Date val;

        DateNode(Node n, int c, Date v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            out.write(this.code | 0);
            out.writeShort(this.val.getYear());
            out.write(this.val.getMonth());
            out.write(this.val.getDay());
        }
    }

    static class TimeNode
    extends Node {
        Time val;

        TimeNode(Node n, int c, Time v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            long ms = this.val.getMillis();
            if (ms % 1000L == 0L) {
                out.write(this.code | 0);
                out.writeInt((int)(ms / 1000L));
            } else {
                out.write(this.code | 1);
                out.writeLong(ms * 1000000L);
            }
        }
    }

    static class ReltimeNode
    extends Node {
        Reltime val;

        ReltimeNode(Node n, int c, Reltime v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            long ms = this.val.get();
            if (ms % 1000L == 0L) {
                out.write(this.code | 0);
                out.writeInt((int)(ms / 1000L));
            } else {
                out.write(this.code | 1);
                out.writeLong(ms * 1000000L);
            }
        }
    }

    static class AbstimeNode
    extends Node {
        Abstime val;

        AbstimeNode(Node n, int c, Abstime v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            if (this.val.getMillisecond() == 0) {
                out.write(this.code | 0);
                out.writeInt((int)(this.val.getMillis2000() / 1000L));
            } else {
                out.write(this.code | 1);
                out.writeLong(this.val.getMillis2000() * 1000000L);
            }
        }
    }

    class ContractNode
    extends StrNode {
        ContractNode(Node n, int c, Contract v) {
            super(n, c, v.toString());
        }
    }

    class StrNode
    extends Node {
        String val;

        StrNode(Node n, int c, String v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            Integer index = (Integer)ObixBinEncoder.this.strTable.get(this.val);
            if (index != null && index < 65535) {
                out.write(this.code | 1);
                out.writeShort(index);
            } else {
                ObixBinEncoder.this.strTable.put(this.val, new Integer(ObixBinEncoder.this.strTable.size()));
                out.write(this.code | 0);
                ObixBinEncoder.writeStr(out, this.val);
            }
        }
    }

    static class RealNode
    extends Node {
        double val;

        RealNode(Node n, int c, double v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            out.write(this.code | 1);
            out.writeDouble(this.val);
        }
    }

    static class IntNode
    extends Node {
        long val;

        IntNode(Node n, int c, long v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            if (0L <= this.val && this.val <= 255L) {
                out.write(this.code | 0);
                out.write((int)this.val);
            } else if (0L <= this.val && this.val <= 65535L) {
                out.write(this.code | 1);
                out.writeShort((short)this.val);
            } else if (Integer.MIN_VALUE <= this.val && this.val <= Integer.MAX_VALUE) {
                out.write(this.code | 2);
                out.writeInt((int)this.val);
            } else {
                out.write(this.code | 3);
                out.writeLong(this.val);
            }
        }
    }

    static class BoolNode
    extends Node {
        boolean val;

        BoolNode(Node n, int c, boolean v) {
            super(n, c);
            this.val = v;
        }

        @Override
        void write(DataOutputStream out) throws IOException {
            if (this.val) {
                out.write(this.code | 1);
            } else {
                out.write(this.code | 0);
            }
        }
    }

    static class Node {
        int code;
        Node next;

        Node(Node tail, int code) {
            if (tail != null) {
                tail.code |= 0x80;
                tail.next = this;
            }
            this.code = code;
        }

        void write(DataOutputStream out) throws IOException {
            out.write(this.code);
        }
    }
}

