/*
 * Decompiled with CFR 0.152.
 */
package obix.io;

import java.io.ByteArrayOutputStream;

public class Base64 {
    private static final char[] encodeTable = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final char PAD = '=';

    public static String encode(String s) {
        return Base64.encode(s.getBytes());
    }

    public static String encode(byte[] buf) {
        return Base64.encode(buf, -1);
    }

    public static String encode(byte[] buf, int linelen) {
        int pos = 0;
        StringBuffer sbuf = new StringBuffer((int)((double)buf.length * 1.33));
        int bytesRemaining = buf.length;
        int index = 0;
        while (bytesRemaining >= 3) {
            int i0 = (0xFF & buf[index]) >> 2;
            int i1 = ((0xFF & buf[index] & 3) << 4) + ((0xFF & buf[index + 1]) >> 4);
            int i2 = ((0xF & buf[index + 1]) << 2) + ((0xFF & buf[index + 2]) >> 6);
            int i3 = 0xFF & buf[index + 2] & 0x3F;
            pos = Base64.append(sbuf, encodeTable[i0], linelen, pos);
            pos = Base64.append(sbuf, encodeTable[i1], linelen, pos);
            pos = Base64.append(sbuf, encodeTable[i2], linelen, pos);
            pos = Base64.append(sbuf, encodeTable[i3], linelen, pos);
            bytesRemaining -= 3;
            index += 3;
        }
        if (bytesRemaining > 0) {
            int i;
            byte[] remainder = new byte[3];
            for (i = 0; i < bytesRemaining; ++i) {
                remainder[i] = buf[index + i];
            }
            for (i = bytesRemaining; i < 3; ++i) {
                remainder[i] = 0;
            }
            int lastOut = bytesRemaining == 1 ? 2 : 3;
            int i0 = (0xFF & remainder[0]) >> 2;
            int i1 = ((0xFF & remainder[0] & 3) << 4) + ((0xFF & remainder[1]) >> 4);
            int i2 = ((0xF & remainder[1]) << 2) + ((0xFF & remainder[2]) >> 6);
            pos = Base64.append(sbuf, encodeTable[i0], linelen, pos);
            if (lastOut > 1) {
                pos = Base64.append(sbuf, encodeTable[i1], linelen, pos);
            }
            if (lastOut > 2) {
                pos = Base64.append(sbuf, encodeTable[i2], linelen, pos);
            }
            int padCount = 4 - lastOut;
            for (int i3 = 0; i3 < padCount; ++i3) {
                pos = Base64.append(sbuf, '=', linelen, pos);
            }
        }
        return sbuf.toString();
    }

    private static final int append(StringBuffer sbuf, char ch, int linelen, int pos) {
        if (linelen != -1) {
            if (pos == linelen) {
                sbuf.append('\n');
                pos = 0;
            }
            ++pos;
        }
        sbuf.append(ch);
        return pos;
    }

    public static byte[] decode(String src) {
        int bits = src.length() * 6;
        ByteArrayOutputStream res = new ByteArrayOutputStream(bits / 8);
        int index = 0;
        int bytesRemaining = src.length();
        while (bytesRemaining >= 4) {
            int val0 = Base64.getVal(src.charAt(index));
            while (val0 == -2 && bytesRemaining > 0) {
                ++index;
                if (--bytesRemaining <= 0) continue;
                val0 = Base64.getVal(src.charAt(index));
            }
            if (bytesRemaining == 0) {
                throw new IllegalStateException("Unexpected end of input.");
            }
            int val1 = Base64.getVal(src.charAt(index + 1));
            while (val1 == -2 && bytesRemaining > 0) {
                ++index;
                if (--bytesRemaining <= 0) continue;
                val1 = Base64.getVal(src.charAt(index + 1));
            }
            if (bytesRemaining == 0) {
                throw new IllegalStateException("Unexpected end of input.");
            }
            int val2 = Base64.getVal(src.charAt(index + 2));
            while (val2 == -2 && bytesRemaining > 0) {
                ++index;
                if (--bytesRemaining <= 0) continue;
                val2 = Base64.getVal(src.charAt(index + 2));
            }
            if (bytesRemaining == 0) {
                throw new IllegalStateException("Unexpected end of input.");
            }
            int val3 = Base64.getVal(src.charAt(index + 3));
            while (val3 == -2 && bytesRemaining > 0) {
                ++index;
                if (--bytesRemaining <= 0) continue;
                val3 = Base64.getVal(src.charAt(index + 3));
            }
            if (bytesRemaining == 0) {
                throw new IllegalStateException("Unexpected end of input.");
            }
            int group = 0;
            int padCount = 0;
            if (val0 != -1) {
                group |= val0 << 18;
            } else {
                ++padCount;
            }
            if (val1 != -1) {
                group |= val1 << 12;
            } else {
                ++padCount;
            }
            if (val2 != -1) {
                group |= val2 << 6;
            } else {
                ++padCount;
            }
            if (val3 != -1) {
                group |= val3;
            } else {
                ++padCount;
            }
            res.write((group & 0xFF0000) >> 16);
            if (val2 != -1) {
                res.write((group & 0xFF00) >> 8);
                if (val3 != -1) {
                    res.write(group & 0xFF);
                }
            }
            bytesRemaining = padCount > 0 ? 0 : (bytesRemaining -= 4);
            index += 4;
        }
        return res.toByteArray();
    }

    public static String decodeToString(String s) {
        return new String(Base64.decode(s));
    }

    private static int getVal(char ch) {
        if (ch == '=') {
            return -1;
        }
        char val = ch;
        if (val >= 'A' && val <= 'Z') {
            return val - 65;
        }
        if (val >= 'a' && val <= 'z') {
            return val - 71;
        }
        if (val >= '0' && val <= '9') {
            return val + 4;
        }
        if (val == '+') {
            return 62;
        }
        if (val == '/') {
            return 63;
        }
        return -2;
    }
}

