/*
 * Decompiled with CFR 0.152.
 */
package obix.asm;

import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.baja.nre.util.IntHashMap;
import obix.asm.Buffer;
import obix.asm.FieldInfo;
import obix.asm.Jvm;

public class ConstantPool {
    Buffer buf = new Buffer();
    int count = 0;
    Hashtable<String, Integer> utfTable = new Hashtable();
    Hashtable<String, Integer> classTable = new Hashtable();
    Hashtable<String, Integer> stringTable = new Hashtable();
    Hashtable<Float, Integer> floatTable = new Hashtable();
    Hashtable<Double, Integer> doubleTable = new Hashtable();
    Hashtable<Long, Integer> longTable = new Hashtable();
    IntHashMap integerTable = new IntHashMap();
    IntHashMap ntTable = new IntHashMap();
    IntHashMap fieldTable = new IntHashMap();
    IntHashMap methodTable = new IntHashMap();
    IntHashMap ifaceTable = new IntHashMap();

    public int utf(String str) {
        Integer ref = this.utfTable.get(str);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(1);
        this.buf.utf(str);
        ++this.count;
        this.utfTable.put(str, new Integer(this.count));
        return this.count;
    }

    public int cls(String className) {
        Integer ref = this.classTable.get(className);
        if (ref != null) {
            return ref;
        }
        int i = this.utf(className);
        this.buf.u1(7);
        this.buf.u2(i);
        ++this.count;
        this.classTable.put(className, new Integer(this.count));
        return this.count;
    }

    public int string(String str) {
        Integer ref = this.stringTable.get(str);
        if (ref != null) {
            return ref;
        }
        int i = this.utf(str);
        this.buf.u1(8);
        this.buf.u2(i);
        ++this.count;
        this.stringTable.put(str, new Integer(this.count));
        return this.count;
    }

    public int integer(int i) {
        Integer ref = (Integer)this.integerTable.get(i);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(3);
        this.buf.u4(i);
        ++this.count;
        this.integerTable.put(i, (Object)new Integer(this.count));
        return this.count;
    }

    public int floatConst(float f) {
        Float key = new Float(f);
        Integer ref = this.floatTable.get(key);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(4);
        this.buf.u4(Float.floatToIntBits(f));
        ++this.count;
        this.floatTable.put(key, new Integer(this.count));
        return this.count;
    }

    public int doubleConst(double d) {
        Double key = new Double(d);
        Integer ref = this.doubleTable.get(key);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(6);
        this.buf.u8(Double.doubleToLongBits(d));
        ++this.count;
        this.doubleTable.put(key, new Integer(this.count));
        ++this.count;
        return this.count - 1;
    }

    public int longConst(long lng) {
        Long key = new Long(lng);
        Integer ref = this.longTable.get(key);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(5);
        this.buf.u8(lng);
        ++this.count;
        this.longTable.put(key, new Integer(this.count));
        ++this.count;
        return this.count - 1;
    }

    public int nt(int name, int type) {
        int hash = name << 16 | type;
        Integer ref = (Integer)this.fieldTable.get(hash);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(12);
        this.buf.u2(name);
        this.buf.u2(type);
        ++this.count;
        this.ntTable.put(hash, (Object)new Integer(this.count));
        return this.count;
    }

    public int field(int cls, int nt) {
        int hash = cls << 16 | nt;
        Integer ref = (Integer)this.fieldTable.get(hash);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(9);
        this.buf.u2(cls);
        this.buf.u2(nt);
        ++this.count;
        this.fieldTable.put(hash, (Object)new Integer(this.count));
        return this.count;
    }

    public int method(int cls, int nt) {
        int hash = cls << 16 | nt;
        Integer ref = (Integer)this.methodTable.get(hash);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(10);
        this.buf.u2(cls);
        this.buf.u2(nt);
        ++this.count;
        this.methodTable.put(hash, (Object)new Integer(this.count));
        return this.count;
    }

    public int iface(int cls, int nt) {
        int hash = cls << 16 | nt;
        Integer ref = (Integer)this.ifaceTable.get(hash);
        if (ref != null) {
            return ref;
        }
        this.buf.u1(11);
        this.buf.u2(cls);
        this.buf.u2(nt);
        ++this.count;
        this.ifaceTable.put(hash, (Object)new Integer(this.count));
        return this.count;
    }

    public int cls(Class<?> c) {
        return this.cls(c.getName().replace('.', '/'));
    }

    public int nt(int name, String type) {
        return this.nt(name, this.utf(type));
    }

    public int nt(String name, String type) {
        return this.nt(this.utf(name), this.utf(type));
    }

    public int method(int cls, int name, String type) {
        return this.method(cls, this.nt(name, type));
    }

    public int method(int cls, String name, String type) {
        return this.method(cls, this.nt(name, type));
    }

    public int method(String cls, String name, String type) {
        return this.method(this.cls(cls), this.nt(name, type));
    }

    public int method(Method m) {
        int cls = this.cls(m.getDeclaringClass());
        int name = this.utf(m.getName());
        int type = this.utf(Jvm.methodDescriptor(m.getParameterTypes(), m.getReturnType()));
        return this.method(cls, this.nt(name, type));
    }

    public int iface(int cls, String name, String type) {
        return this.iface(cls, this.nt(name, type));
    }

    public int field(int cls, int name, String type) {
        return this.field(cls, this.nt(name, type));
    }

    public int field(int cls, String name, String type) {
        return this.field(cls, this.nt(name, type));
    }

    public int field(FieldInfo fi) {
        return this.field(fi.asm.thisClass, this.nt(fi.name, fi.type));
    }
}

