/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import obix.Obj;
import obix.Val;

public class Uri
extends Val {
    private String val;
    private boolean parsed;
    private boolean abs;
    private String auth;
    private String scheme;
    private String addr;
    private String host;
    private int port = -1;
    private String path;
    private Query query;
    private String frag;
    private Obj resolved;

    public Uri(String name, String val) {
        super(name);
        this.set(val);
    }

    public Uri(String val) {
        this.set(val);
    }

    public Uri() {
        this.set("");
    }

    public Uri normalize(Uri base) {
        try {
            if (this.val.startsWith("obix:")) {
                return this;
            }
            base.checkAbsolute();
            URL url = new URL(new URL(base.val), this.val);
            return new Uri(url.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot normalize " + base.val + " + " + this.val);
        }
    }

    public boolean isAbsolute() {
        this.parse();
        return this.abs;
    }

    public boolean isRelative() {
        this.parse();
        return !this.abs;
    }

    public void checkAbsolute() {
        this.parse();
        if (!this.abs) {
            throw new IllegalStateException("Uri is not absolute: " + this.val);
        }
    }

    public boolean isFragment() {
        return this.val.startsWith("#");
    }

    public String getAuthority() {
        this.parse();
        return this.auth;
    }

    public Uri getAuthorityUri() {
        this.parse();
        this.checkAbsolute();
        return new Uri(this.auth);
    }

    public String getScheme() {
        this.parse();
        return this.scheme;
    }

    public boolean contains(Uri uri) {
        this.checkAbsolute();
        if (uri.isRelative()) {
            return true;
        }
        return uri.val.toLowerCase().startsWith(this.val.toLowerCase());
    }

    public String getAddress() {
        this.parse();
        return this.addr;
    }

    public String getHost() {
        this.parse();
        return this.host;
    }

    public int getPort() {
        this.parse();
        return this.port;
    }

    public String getPath() {
        this.parse();
        return this.path;
    }

    public Query getQuery() {
        this.parse();
        return this.query;
    }

    public String getFragment() {
        this.parse();
        return this.frag;
    }

    public URL toURL() {
        this.checkAbsolute();
        try {
            return new URL(this.val);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid url: " + this.val);
        }
    }

    public Uri parent() {
        this.parse();
        if (this.path.length() <= 1) {
            return null;
        }
        int lastSlash = this.path.lastIndexOf(47, this.path.length() - 2);
        if (lastSlash < 0) {
            return null;
        }
        if (lastSlash == 0) {
            if (this.auth != null) {
                return new Uri(this.auth);
            }
            return null;
        }
        if (this.auth != null) {
            return new Uri(this.auth + this.path.substring(1, lastSlash));
        }
        return new Uri(this.path.substring(0, lastSlash));
    }

    public static Query parseQuery(String str) {
        if (str == null) {
            return null;
        }
        Query q = new Query(str);
        try {
            StringTokenizer st = new StringTokenizer(str, "&");
            while (st.hasMoreTokens()) {
                String val;
                String key;
                String tok = st.nextToken();
                int eq = tok.indexOf(61);
                if (eq < 0) {
                    key = tok;
                    val = "true";
                } else {
                    key = tok.substring(0, eq);
                    val = tok.substring(eq + 1);
                }
                q.keys.add(key);
                q.map.put(key, val);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return q;
    }

    public Uri removeQueryParam(String key) {
        return this.addQueryParam(key, null);
    }

    public Uri addQueryParam(String key, String value) {
        StringBuffer newq = new StringBuffer();
        boolean found = false;
        Query q = this.getQuery();
        if (q != null) {
            String[] keys = q.keys();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i].equals(key)) {
                    if (value != null) {
                        if (newq.length() > 0) {
                            newq.append('&');
                        }
                        newq.append(key).append('=').append(value);
                    }
                    found = true;
                    continue;
                }
                if (newq.length() > 0) {
                    newq.append('&');
                }
                newq.append(keys[i]).append('=').append(q.get(keys[i], null));
            }
        }
        if (!found && value != null) {
            if (newq.length() > 0) {
                newq.append('&');
            }
            newq.append(key).append('=').append(value);
        }
        String result = this.auth + this.path.substring(1);
        if (newq.length() > 0) {
            result = result + "?" + newq;
        }
        return new Uri(result);
    }

    private void parse() {
        try {
            block6: {
                if (this.parsed) {
                    return;
                }
                try {
                    URL url = new URL(this.val);
                    this.abs = true;
                    this.scheme = url.getProtocol();
                    this.addr = url.getAuthority();
                    this.auth = this.scheme + "://" + this.addr + "/";
                    this.host = url.getHost();
                    this.port = url.getPort();
                    this.path = url.getPath();
                    this.query = Uri.parseQuery(url.getQuery());
                    this.frag = url.getRef();
                }
                catch (MalformedURLException e) {
                    int qmark;
                    this.abs = false;
                    this.path = this.val;
                    int pound = this.path.indexOf(35);
                    if (pound >= 0) {
                        this.frag = this.path.substring(pound + 1);
                        this.path = this.path.substring(0, pound);
                    }
                    if ((qmark = this.path.indexOf(63)) < 0) break block6;
                    this.query = Uri.parseQuery(this.path.substring(qmark + 1));
                    this.path = this.path.substring(0, qmark);
                }
            }
            this.parsed = true;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid uri: " + this.val);
        }
    }

    public boolean isResolved() {
        return this.resolved != null;
    }

    public Obj getResolved() {
        return this.resolved;
    }

    public void setResolved(Obj resolved) {
        this.resolved = resolved;
    }

    public String get() {
        return this.val;
    }

    public void set(String val) {
        if (val == null) {
            throw new IllegalArgumentException("val cannot be null");
        }
        this.parsed = false;
        this.val = val;
    }

    @Override
    public String getElement() {
        return "uri";
    }

    @Override
    public int getBinCode() {
        return 28;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Uri) {
            return ((Uri)that).val.equals(this.val);
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        return this.val.compareTo(((Uri)that).val);
    }

    @Override
    public String encodeVal() {
        return this.val;
    }

    @Override
    public void decodeVal(String val) throws Exception {
        this.set(val);
    }

    @Override
    public String encodeJava() {
        return '\"' + this.val + '\"';
    }

    public static class Query {
        ArrayList<String> keys = new ArrayList();
        Map<String, String> map = new HashMap<String, String>();
        String str;

        Query(String str) {
            this.str = str;
        }

        public String[] keys() {
            return this.keys.toArray(new String[this.keys.size()]);
        }

        public String get(String key, String def) {
            String val = this.map.get(key);
            if (val == null) {
                return def;
            }
            return val;
        }

        public String toString() {
            return this.str;
        }
    }
}

