/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import obix.Abstime;
import obix.Bool;
import obix.Contract;
import obix.Date;
import obix.Enum;
import obix.Err;
import obix.Feed;
import obix.IObj;
import obix.Int;
import obix.List;
import obix.Op;
import obix.Real;
import obix.Ref;
import obix.Reltime;
import obix.Status;
import obix.Str;
import obix.Time;
import obix.Uri;
import obix.Val;
import obix.io.ObixEncoder;

public class Obj
implements IObj {
    static Map<String, Class<?>> elemNameToClass = new HashMap();
    static Map<Integer, Class<?>> binCodeToClass = new HashMap();
    private String name;
    private Uri href;
    private Contract is;
    private Obj parent;
    private Map<String, Obj> kidsByName;
    private Obj kidsHead;
    private Obj kidsTail;
    private int kidsCount;
    private Obj prev;
    private Obj next;
    private Status status = Status.ok;
    private String display;
    private String displayName;
    private Uri icon;
    private boolean writable;
    private boolean isNull;

    public static Class<?> toClass(String elemName) {
        return elemNameToClass.get(elemName);
    }

    public static Class<?> toClass(int binCode) {
        return binCodeToClass.get(new Integer(binCode));
    }

    public static Obj toObj(String elemName) {
        Class<?> cls = Obj.toClass(elemName);
        if (cls == null) {
            return null;
        }
        try {
            return (Obj)cls.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException(e.toString());
        }
    }

    private static void mapClass(String elemName, int binCode, Class<?> cls) {
        elemNameToClass.put(elemName, cls);
        binCodeToClass.put(new Integer(binCode), cls);
    }

    public Obj(String name) {
        this.name = name;
    }

    public Obj() {
        this(null);
    }

    public String getElement() {
        return "obj";
    }

    public int getBinCode() {
        return 4;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("name is already set");
        }
        if (this.parent != null) {
            throw new IllegalStateException("obj is already parented");
        }
        this.name = name;
    }

    @Override
    public Obj getParent() {
        return this.parent;
    }

    @Override
    public Obj getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public Uri getHref() {
        return this.href;
    }

    @Override
    public Uri getNormalizedHref() {
        if (this.href == null) {
            return null;
        }
        return this.href.normalize(this.getRoot().getHref());
    }

    @Override
    public void setHref(Uri href) {
        this.href = href;
    }

    public boolean is(String uri) {
        return this.is(new Uri(uri));
    }

    public boolean is(Uri uri) {
        if (this.is == null) {
            return false;
        }
        return this.is.contains(uri);
    }

    @Override
    public Contract getIs() {
        return this.is;
    }

    @Override
    public void setIs(Contract is) {
        this.is = is;
    }

    @Override
    public boolean isVal() {
        return this instanceof Val;
    }

    @Override
    public boolean isBool() {
        return this instanceof Bool;
    }

    @Override
    public boolean isInt() {
        return this instanceof Int;
    }

    @Override
    public boolean isReal() {
        return this instanceof Real;
    }

    @Override
    public boolean isEnum() {
        return this instanceof Enum;
    }

    @Override
    public boolean isStr() {
        return this instanceof Str;
    }

    @Override
    public boolean isAbstime() {
        return this instanceof Abstime;
    }

    @Override
    public boolean isReltime() {
        return this instanceof Reltime;
    }

    @Override
    public boolean isUri() {
        return this instanceof Uri;
    }

    @Override
    public boolean isList() {
        return this instanceof List;
    }

    @Override
    public boolean isOp() {
        return this instanceof Op;
    }

    @Override
    public boolean isRef() {
        return this instanceof Ref;
    }

    @Override
    public boolean isFeed() {
        return this instanceof Feed;
    }

    @Override
    public boolean isErr() {
        return this instanceof Err;
    }

    @Override
    public boolean getBool() {
        return ((Bool)this).get();
    }

    @Override
    public long getInt() {
        return ((Int)this).get();
    }

    @Override
    public double getReal() {
        return ((Real)this).get();
    }

    @Override
    public String getStr() {
        return ((Str)this).get();
    }

    @Override
    public void setBool(boolean val) {
        ((Bool)this).set(val);
    }

    @Override
    public void setInt(long val) {
        ((Int)this).set(val);
    }

    @Override
    public void setReal(double val) {
        ((Real)this).set(val);
    }

    @Override
    public void setStr(String val) {
        ((Str)this).set(val);
    }

    @Override
    public String toDisplayString() {
        if (this.display != null) {
            return this.display;
        }
        if (this instanceof Val) {
            return ((Val)this).encodeVal();
        }
        if (this.is != null && this.is.size() > 0) {
            return this.is.toString();
        }
        return "obix:" + this.getElement();
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(String display) {
        this.display = display;
    }

    @Override
    public String toDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        if (this.name != null) {
            return this.name;
        }
        return this.getElement();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Uri getIcon() {
        return this.icon;
    }

    @Override
    public void setIcon(Uri icon) {
        this.icon = icon;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(Status status) {
        if (status == null) {
            status = Status.ok;
        }
        this.status = status;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public void setWritable(boolean writable) {
        this.setWritable(writable, false);
    }

    @Override
    public void setWritable(boolean writable, boolean recursive) {
        this.writable = writable;
        if (recursive) {
            Obj[] kids = this.list();
            for (int i = 0; i < kids.length; ++i) {
                kids[i].setWritable(writable, recursive);
            }
        }
    }

    public boolean has(String name) {
        if (this.kidsByName == null) {
            return false;
        }
        return this.kidsByName.get(name) != null;
    }

    @Override
    public Obj get(String name) {
        if (this.kidsByName == null) {
            return null;
        }
        return this.kidsByName.get(name);
    }

    public Uri getChildHref(String name) {
        Obj kid = this.get(name);
        if (kid == null) {
            throw new IllegalStateException("Missing child object: " + name);
        }
        if (kid.getHref() == null) {
            throw new IllegalStateException("Child missing href : " + name);
        }
        return kid.getNormalizedHref();
    }

    @Override
    public int size() {
        return this.kidsCount;
    }

    @Override
    public Obj[] list() {
        Obj[] list = new Obj[this.kidsCount];
        int n = 0;
        Obj p = this.kidsHead;
        while (p != null) {
            list[n++] = p;
            p = p.next;
        }
        return list;
    }

    public Object[] list(Class<?> cls) {
        Object[] temp = new Object[this.kidsCount];
        int count = 0;
        Obj p = this.kidsHead;
        while (p != null) {
            if (cls.isInstance(p)) {
                temp[count++] = p;
            }
            p = p.next;
        }
        Object[] result = (Object[])Array.newInstance(cls, count);
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }

    public Obj add(String name, Obj kid) {
        kid.setName(name);
        return this.add(kid);
    }

    @Override
    public Obj add(Obj kid) {
        if (kid.parent != null || kid.prev != null || kid.next != null) {
            throw new IllegalStateException("Child is already parented");
        }
        if (kid.name != null && this.kidsByName != null && this.kidsByName.containsKey(kid.name)) {
            throw new IllegalStateException("Duplicate child name '" + kid.name + "'");
        }
        if (kid.name != null) {
            if (this.kidsByName == null) {
                this.kidsByName = new HashMap<String, Obj>();
            }
            this.kidsByName.put(kid.name, kid);
        }
        if (this.kidsTail == null) {
            this.kidsHead = this.kidsTail = kid;
        } else {
            this.kidsTail.next = kid;
            kid.prev = this.kidsTail;
            this.kidsTail = kid;
        }
        kid.parent = this;
        ++this.kidsCount;
        return this;
    }

    @Override
    public Obj addAll(Obj[] kids) {
        for (int i = 0; i < kids.length; ++i) {
            this.add(kids[i]);
        }
        return this;
    }

    @Override
    public void remove(Obj kid) {
        if (kid.parent != this) {
            throw new IllegalStateException("Not parented by me");
        }
        if (kid.name != null) {
            this.kidsByName.remove(kid.name);
        }
        if (this.kidsHead == kid) {
            this.kidsHead = kid.next;
        } else {
            kid.prev.next = kid.next;
        }
        if (this.kidsTail == kid) {
            this.kidsTail = kid.prev;
        } else {
            kid.next.prev = kid.prev;
        }
        kid.parent = null;
        kid.prev = null;
        kid.next = null;
        --this.kidsCount;
    }

    @Override
    public void replace(Obj oldObj, Obj newObj) {
        if (!oldObj.name.equals(newObj.name)) {
            throw new IllegalStateException("Mismatched names: " + oldObj.name + " != " + newObj.name);
        }
        if (oldObj.parent != this) {
            throw new IllegalStateException("oldObj not parented by me");
        }
        if (newObj.parent != null) {
            throw new IllegalStateException("newObj already parented");
        }
        this.kidsByName.put(newObj.name, newObj);
        newObj.parent = this;
        newObj.prev = oldObj.prev;
        if (newObj.prev != null) {
            newObj.prev.next = newObj;
        }
        newObj.next = oldObj.next;
        if (newObj.next != null) {
            newObj.next.prev = newObj;
        }
        if (this.kidsHead == oldObj) {
            this.kidsHead = newObj;
        }
        if (this.kidsTail == oldObj) {
            this.kidsTail = newObj;
        }
        oldObj.parent = null;
        oldObj.prev = null;
        oldObj.next = null;
    }

    @Override
    public void removeThis() {
        if (this.parent == null) {
            throw new IllegalStateException("Not parented");
        }
        this.parent.remove(this);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("<").append(this.getElement());
        if (this.name != null) {
            s.append(" name=\"").append(this.name).append('\"');
        }
        if (this.href != null) {
            s.append(" href=\"").append(this.href.get()).append('\"');
        }
        if (this instanceof Val) {
            s.append(" val=\"").append(((Val)this).encodeVal()).append('\"');
        }
        s.append("/>");
        return s.toString();
    }

    public void dump() {
        ObixEncoder.dump(this);
    }

    public void setHref(String href) {
        this.href = new Uri(href);
    }

    public void setIcon(String icon) {
        this.icon = new Uri(icon);
    }

    public void setIs(String is) {
        this.is = new Contract(is);
    }

    public void addContract(String toAdd) {
        this.addContract(toAdd, false);
    }

    public void addContract(String toAdd, boolean primary) {
        Contract list = this.getIs();
        if (list == null || list.size() == 0) {
            this.setIs(toAdd);
            return;
        }
        if (list.contains(new Uri(toAdd))) {
            return;
        }
        this.setIs(primary ? toAdd + " " + list : list + " " + toAdd);
    }

    static {
        Obj.mapClass("obj", 4, Obj.class);
        Obj.mapClass("str", 20, Str.class);
        Obj.mapClass("bool", 8, Bool.class);
        Obj.mapClass("int", 12, Int.class);
        Obj.mapClass("enum", 24, Enum.class);
        Obj.mapClass("list", 48, List.class);
        Obj.mapClass("real", 16, Real.class);
        Obj.mapClass("uri", 28, Uri.class);
        Obj.mapClass("abstime", 32, Abstime.class);
        Obj.mapClass("reltime", 36, Reltime.class);
        Obj.mapClass("time", 44, Time.class);
        Obj.mapClass("date", 40, Date.class);
        Obj.mapClass("op", 52, Op.class);
        Obj.mapClass("ref", 60, Ref.class);
        Obj.mapClass("err", 64, Err.class);
        Obj.mapClass("feed", 56, Feed.class);
    }
}

