/*
 * Decompiled with CFR 0.152.
 */
package obix;

import obix.Val;

public class Date
extends Val {
    private int year = 2000;
    private int mon = 1;
    private int day = 1;
    private Date min;
    private Date max;
    private String tz;

    public Date(String name, int year, int mon, int day) {
        super(name);
        this.set(year, mon, day);
    }

    public Date(String name) {
        super(name);
    }

    public Date(int year, int mon, int day) {
        this.set(year, mon, day);
    }

    public Date() {
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.mon;
    }

    public final int getDay() {
        return this.day;
    }

    public void set(int year, int mon, int day) {
        if (year < 1900 || year > 2100) {
            throw new IllegalArgumentException("year not 1900-2100: " + year);
        }
        if (mon < 1 || mon > 12) {
            throw new IllegalArgumentException("mon not 1-12: " + mon);
        }
        if (day < 0 || day > 31) {
            throw new IllegalArgumentException("day not 1-31: " + day);
        }
        this.year = year;
        this.mon = mon;
        this.day = day;
    }

    @Override
    public String getElement() {
        return "date";
    }

    @Override
    public int getBinCode() {
        return 40;
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Date) {
            Date x = (Date)that;
            return this.year == x.year && this.mon == x.mon && this.day == x.day;
        }
        return false;
    }

    @Override
    public int compareTo(Val that) {
        Date a = this;
        Date b = (Date)that;
        if (a.year < b.year) {
            return -1;
        }
        if (a.year > b.year) {
            return 1;
        }
        if (a.mon < b.mon) {
            return -1;
        }
        if (a.mon > b.mon) {
            return 1;
        }
        if (a.day < b.day) {
            return -1;
        }
        if (a.day > b.day) {
            return 1;
        }
        return 0;
    }

    @Override
    public String encodeVal() {
        StringBuffer s = new StringBuffer();
        s.append(this.year);
        s.append('-');
        if (this.mon < 10) {
            s.append('0');
        }
        s.append(this.mon);
        s.append('-');
        if (this.day < 10) {
            s.append('0');
        }
        s.append(this.day);
        return s.toString();
    }

    public static Date parse(String s) throws Exception {
        Date r = new Date();
        r.decodeVal(s);
        return r;
    }

    @Override
    public void decodeVal(String s) throws Exception {
        try {
            if (s.length() != 10 || s.charAt(4) != '-' || s.charAt(7) != '-') {
                throw new Exception();
            }
            int year = Integer.parseInt(s.substring(0, 4));
            int mon = Integer.parseInt(s.substring(5, 7));
            int day = Integer.parseInt(s.substring(8));
            this.set(year, mon, day);
        }
        catch (Exception e) {
            throw new Exception("Invalid date: " + s);
        }
    }

    public Date getMin() {
        return this.min;
    }

    public void setMin(Date min) {
        this.min = min;
    }

    public Date getMax() {
        return this.max;
    }

    public void setMax(Date max) {
        this.max = max;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String tz) {
        this.tz = tz;
    }
}

