/*
 * Decompiled with CFR 0.152.
 */
package obix;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import obix.Reltime;
import obix.Val;

public class Abstime
extends Val {
    private DateFormat format = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    public static final long JAVA_2000 = 946684800000L;
    private static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final TimeZone defaultTimeZone = TimeZone.getDefault();
    static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private long millis;
    private int bits0;
    private int bits1;
    private TimeZone timeZone;
    private Abstime min;
    private Abstime max;
    private String tz;

    public Abstime(String name, long millis) {
        super(name);
        this.set(millis, defaultTimeZone);
    }

    public Abstime(String name) {
        super(name);
        this.set(0L, defaultTimeZone);
    }

    public Abstime(long millis, TimeZone timeZone) {
        this.set(millis, timeZone);
    }

    public Abstime(Abstime t, TimeZone timeZone) {
        this.set(t.millis, timeZone);
    }

    public Abstime(long millis) {
        this(millis, defaultTimeZone);
    }

    public Abstime(int year, int month, int day, int hour, int min, int sec, int millis, TimeZone timeZone) {
        this.set(Abstime.toMillis(year, month, day, hour, min, sec, millis, timeZone), timeZone);
    }

    public Abstime(int year, int month, int day, int hour, int min, int sec, int millis) {
        this(year, month, day, hour, min, sec, millis, defaultTimeZone);
    }

    public Abstime(int year, int month, int day, int hour, int min, int sec) {
        this(year, month, day, hour, min, sec, 0, defaultTimeZone);
    }

    public Abstime(int year, int month, int day, int hour, int min) {
        this(year, month, day, hour, min, 0, 0, defaultTimeZone);
    }

    public Abstime(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0, defaultTimeZone);
    }

    public Abstime() {
        this.set(0L, defaultTimeZone);
    }

    public long getMillis() {
        return this.millis;
    }

    public long getMillis2000() {
        return this.millis - 946684800000L;
    }

    public final int getYear() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 >> 16 & 0xFFFF;
    }

    public final int getMonth() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 25 & 0xF;
    }

    public final int getDay() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 20 & 0x1F;
    }

    public final int getHour() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 15 & 0x1F;
    }

    public final int getMinute() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 9 & 0x3F;
    }

    public final int getSecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 >> 3 & 0x3F;
    }

    public final int getMillisecond() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits0 & 0xFFFF;
    }

    public final int getWeekday() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return this.bits1 & 7;
    }

    public final long getTimeOfDayMillis() {
        return (long)(this.getHour() * 60 * 60) * 1000L + (long)(this.getMinute() * 60) * 1000L + (long)this.getSecond() * 1000L + (long)this.getMillisecond();
    }

    public String format() {
        if (this.isNull() || this.millis == 0L) {
            return "null";
        }
        return this.format.format(new Date(this.millis));
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getTimeZoneOffset() {
        if (!this.inDaylightTime()) {
            return this.timeZone.getRawOffset();
        }
        GregorianCalendar cal = new GregorianCalendar(this.timeZone);
        cal.setTime(new Date(this.millis));
        return cal.get(15) + cal.get(16);
    }

    public boolean inDaylightTime() {
        if (this.bits0 == 0) {
            this.millisToFields();
        }
        return (this.bits1 >> 29 & 1) != 0;
    }

    public Abstime toLocalTime() {
        if (this.timeZone.equals(defaultTimeZone)) {
            return this;
        }
        return new Abstime(this, defaultTimeZone);
    }

    public Abstime toUtcTime() {
        if (this.timeZone.equals(utcTimeZone)) {
            return this;
        }
        return new Abstime(this, utcTimeZone);
    }

    @Override
    public int compareTo(Val that) {
        Abstime t = (Abstime)that;
        if (this.millis < t.millis) {
            return -1;
        }
        if (this.millis == t.millis) {
            return 0;
        }
        return 1;
    }

    public boolean isBefore(Abstime x) {
        return this.compareTo(x) < 0;
    }

    public boolean isAfter(Abstime x) {
        return this.compareTo(x) > 0;
    }

    public int hashCode() {
        return (int)(this.millis ^ this.millis >> 32);
    }

    @Override
    public boolean valEquals(Val that) {
        if (that instanceof Abstime) {
            return ((Abstime)that).millis == this.millis;
        }
        return false;
    }

    public boolean dateEquals(Abstime that) {
        return that.getYear() == this.getYear() && that.getMonth() == this.getMonth() && that.getDay() == this.getDay();
    }

    public boolean timeEquals(Abstime that) {
        return that.getTimeOfDayMillis() == this.getTimeOfDayMillis();
    }

    public Abstime add(Reltime relTime) {
        return new Abstime(this.millis + relTime.getMillis(), this.timeZone);
    }

    public Abstime subtract(Reltime relTime) {
        return new Abstime(this.millis - relTime.getMillis(), this.timeZone);
    }

    public Reltime delta(Abstime t2) {
        return new Reltime(t2.millis - this.millis);
    }

    public Abstime timeOfDay(int hour, int min, int sec, int millis) {
        return new Abstime(this.getYear(), this.getMonth(), this.getDay(), hour, min, sec, millis, this.timeZone);
    }

    public Abstime nextDay() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        if (day == Abstime.getDaysInMonth(year, month)) {
            day = 1;
            if (month == 12) {
                month = 1;
                ++year;
            } else {
                ++month;
            }
        } else {
            ++day;
        }
        return new Abstime(year, month, day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevDay() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        if (day == 1) {
            if (month == 1) {
                month = 12;
                --year;
            } else {
                --month;
            }
            day = Abstime.getDaysInMonth(year, month);
        } else {
            --day;
        }
        return new Abstime(year, month, day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextMonth() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        if (month == 12) {
            month = 1;
            ++year;
        } else if (day == Abstime.getDaysInMonth(year, month)) {
            day = Abstime.getDaysInMonth(year, ++month);
        } else if (day > Abstime.getDaysInMonth(year, ++month)) {
            day = Abstime.getDaysInMonth(year, month);
        }
        return new Abstime(year, month, day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevMonth() {
        int year = this.getYear();
        int month = this.getMonth();
        int day = this.getDay();
        if (month == 1) {
            month = 12;
            --year;
        } else if (day == Abstime.getDaysInMonth(year, month)) {
            day = Abstime.getDaysInMonth(year, --month);
        } else if (day > Abstime.getDaysInMonth(year, --month)) {
            day = Abstime.getDaysInMonth(year, month);
        }
        return new Abstime(year, month, day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return new Abstime(this.getYear() + 1, this.getMonth(), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime prevYear() {
        int day = this.getDay();
        if (this.isLeapDay()) {
            day = 28;
        }
        return new Abstime(this.getYear() - 1, this.getMonth(), day, this.getHour(), this.getMinute(), this.getSecond(), this.getMillisecond(), this.timeZone);
    }

    public Abstime nextWeekday(int weekday) {
        Abstime t = this.nextDay();
        while (t.getWeekday() != weekday) {
            t = t.nextDay();
        }
        return t;
    }

    public Abstime prevWeekday(int weekday) {
        Abstime t = this.prevDay();
        while (t.getWeekday() != weekday) {
            t = t.prevDay();
        }
        return t;
    }

    public boolean isLeapDay() {
        return this.getMonth() == 2 && this.getDay() == 29;
    }

    public static boolean isLeapYear(int year) {
        if (year >= 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    public static int getDaysInMonth(int year, int month) {
        Abstime.checkMonth(month);
        if (month == 2) {
            return Abstime.isLeapYear(year) ? 29 : 28;
        }
        return daysInMonth[month - 1];
    }

    public static int getDaysInYear(int year) {
        return Abstime.isLeapYear(year) ? 366 : 365;
    }

    public long get() {
        return this.millis;
    }

    public void set(long millis, TimeZone timeZone) {
        this.millis = millis;
        this.timeZone = timeZone;
        this.bits1 = 0;
        this.bits0 = 0;
        if (timeZone != null) {
            this.tz = timeZone.getID();
        }
    }

    @Override
    public String getElement() {
        return "abstime";
    }

    @Override
    public int getBinCode() {
        return 32;
    }

    @Override
    public String encodeVal() {
        StringBuffer s = new StringBuffer(32);
        int year = this.getYear();
        if (year < 10) {
            s.append('0');
        }
        if (year < 100) {
            s.append('0');
        }
        if (year < 1000) {
            s.append('0');
        }
        s.append(year).append('-');
        int month = this.getMonth();
        if (month < 10) {
            s.append('0');
        }
        s.append(month).append('-');
        int day = this.getDay();
        if (day < 10) {
            s.append('0');
        }
        s.append(day).append('T');
        int hour = this.getHour();
        if (hour < 10) {
            s.append('0');
        }
        s.append(hour).append(':');
        int min = this.getMinute();
        if (min < 10) {
            s.append('0');
        }
        s.append(min).append(':');
        int sec = this.getSecond();
        if (sec < 10) {
            s.append('0');
        }
        s.append(sec).append('.');
        int millis = this.getMillisecond();
        if (millis < 10) {
            s.append('0');
        }
        if (millis < 100) {
            s.append('0');
        }
        s.append(millis);
        int offset = this.getTimeZoneOffset();
        if (offset == 0) {
            s.append('Z');
        } else {
            int hrOff = Math.abs(offset / 3600000);
            int minOff = Math.abs(offset % 3600000 / 60000);
            if (offset < 0) {
                s.append('-');
            } else {
                s.append('+');
            }
            if (hrOff < 10) {
                s.append('0');
            }
            s.append(hrOff);
            s.append(':');
            if (minOff < 10) {
                s.append('0');
            }
            s.append(minOff);
        }
        return s.toString();
    }

    public static Abstime parse(String val) throws Exception {
        Abstime a = new Abstime();
        a.decodeVal(val);
        return a;
    }

    @Override
    public void decodeVal(String val) throws Exception {
        char[] c = val.toCharArray();
        try {
            char sign;
            int i = 0;
            int year = (c[i++] - 48) * 1000 + (c[i++] - 48) * 100 + (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int mon = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != '-') {
                throw new Exception();
            }
            int day = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != 'T') {
                throw new Exception();
            }
            int hour = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int min = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            if (c[i++] != ':') {
                throw new Exception();
            }
            int sec = (c[i++] - 48) * 10 + (c[i++] - 48) * 1;
            int ms = 0;
            if (c[i] == '.') {
                int n = ++i;
                ms = (c[n] - 48) * 100;
                if ('0' <= c[++i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 10;
                }
                if ('0' <= c[i] && c[i] <= '9') {
                    ms += (c[i++] - 48) * 1;
                }
                while (i < c.length && '0' <= c[i] && c[i] <= '9') {
                    ++i;
                }
            }
            int tzOff = 0;
            if ((sign = c[i++]) != 'Z') {
                if (sign != '+' && sign != '-') {
                    throw new Exception();
                }
                int hrOff = c[i++] - 48;
                if (i < c.length && c[i] != ':') {
                    hrOff = hrOff * 10 + (c[i++] - 48);
                }
                int minOff = 0;
                if (i < c.length) {
                    if (c[i++] != ':') {
                        throw new Exception();
                    }
                    minOff = 10 * (c[i++] - 48) + (c[i++] - 48);
                }
                tzOff = hrOff * 3600000 + minOff * 60000;
                if (sign == '-') {
                    tzOff *= -1;
                }
            }
            GregorianCalendar cal = new GregorianCalendar(year, mon - 1, day, hour, min, sec);
            cal.set(14, ms);
            ((Calendar)cal).setTimeZone(new SimpleTimeZone(tzOff, "Offset"));
            this.set(cal.getTime().getTime(), this.timeZone);
        }
        catch (Exception e) {
            throw new Exception("Invalid abstime: " + val);
        }
    }

    @Override
    public String encodeJava() {
        return String.valueOf(this.millis) + "L";
    }

    public Abstime getMin() {
        return this.min;
    }

    public void setMin(Abstime min) {
        this.min = min;
    }

    public Abstime getMax() {
        return this.max;
    }

    public void setMax(Abstime max) {
        this.max = max;
    }

    public String getTz() {
        return this.tz;
    }

    public void setTz(String tz) {
        if (tz == null) {
            return;
        }
        TimeZone newTz = TimeZone.getTimeZone(tz);
        if (newTz == null) {
            System.out.println("no timezone for tz facet:" + tz);
            return;
        }
        if (!newTz.equals(this.timeZone)) {
            this.bits1 = 0;
            this.bits0 = 0;
        }
        this.tz = tz;
        this.timeZone = newTz;
    }

    private static long toMillis(int year, int month, int day, int hour, int min, int sec, int millis, TimeZone timeZone) {
        Abstime.checkMonth(month);
        GregorianCalendar c = new GregorianCalendar(timeZone);
        c.set(year, month - 1, day, hour, min, sec);
        c.set(14, millis);
        return c.getTime().getTime();
    }

    private static int checkMonth(int month) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Month must be 1 to 12");
        }
        return month;
    }

    private void millisToFields() {
        GregorianCalendar calendar = new GregorianCalendar(this.timeZone);
        Date date = new Date(this.millis);
        calendar.setTime(date);
        int x = calendar.get(1);
        this.bits0 |= (x & 0xFFFF) << 16;
        x = calendar.get(14);
        this.bits0 |= (x & 0xFFFF) << 0;
        x = calendar.get(2) + 1;
        this.bits1 |= (x & 0xF) << 25;
        x = calendar.get(5);
        this.bits1 |= (x & 0x1F) << 20;
        x = calendar.get(11);
        this.bits1 |= (x & 0x1F) << 15;
        x = calendar.get(12);
        this.bits1 |= (x & 0x3F) << 9;
        x = calendar.get(13);
        this.bits1 |= (x & 0x3F) << 3;
        x = calendar.get(7) - 1;
        this.bits1 |= (x & 7) << 0;
        if (this.timeZone.inDaylightTime(date)) {
            this.bits1 |= 0x20000000;
        }
    }
}

