/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BModuleList;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.FilePathComparator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.data.BIDataValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.Array;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.PatternFilter;

public class BAxOfflineBackup
extends BComponent {
    public static final Property offlineExcludeFiles = BAxOfflineBackup.newProperty((int)0, (String)"*.lock;*backup*;console.*;config.bog.b*;config_backup*", null);
    public static final Property offlineExcludeDirectories = BAxOfflineBackup.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    public static final Type TYPE = Sys.loadType(BAxOfflineBackup.class);
    private static final BIcon icon = BIcon.std((String)"backup.png");
    private static final BOrdList DEFAULT_PLATFORM_BACKUP = BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:!certificates"), BOrd.make((String)"file:!daemon"), BOrd.make((String)"file:!lexicon"), BOrd.make((String)"file:!lib"), BOrd.make((String)"file:!licenses"), BOrd.make((String)"file:!platform"), BOrd.make((String)"file:!users"), BOrd.make((String)"file:!workbench"), BOrd.make((String)"file:!sedona"), BOrd.make((String)"file:!fips")});
    private static final BOrdList DEFAULT_SECURITY_BACKUP = BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:!security/ssl.tks"), BOrd.make((String)"file:!security/keystore.bks"), BOrd.make((String)"file:!security/cacerts.bks"), BOrd.make((String)"file:!security/exemptions.tes"), BOrd.make((String)"file:!security/.km"), BOrd.make((String)"file:!security/.kr"), BOrd.make((String)"file:!workbench/security/keystore.bks"), BOrd.make((String)"file:!workbench/security/cacerts.bks"), BOrd.make((String)"file:!workbench/security/exemptions.tes"), BOrd.make((String)"file:!workbench/security/.km"), BOrd.make((String)"file:!workbench/security/.kr")});

    public String getOfflineExcludeFiles() {
        return this.getString(offlineExcludeFiles);
    }

    public void setOfflineExcludeFiles(String v) {
        this.setString(offlineExcludeFiles, v, null);
    }

    public BOrdList getOfflineExcludeDirectories() {
        return (BOrdList)this.get(offlineExcludeDirectories);
    }

    public void setOfflineExcludeDirectories(BOrdList v) {
        this.set(offlineExcludeDirectories, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void zip(JobLog log, BBackupService.ICanceler canceler, BRemoteDaemonPlatform daemonPlatform, OutputStream out, boolean close) throws Exception {
        this.zip(out, close, new AxBackupOp(log, canceler, daemonPlatform));
    }

    public void zip(BJob job, BRemoteDaemonPlatform daemonPlatform, OutputStream out, boolean close) throws Exception {
        this.zip(out, close, new AxBackupOp(job, BAxOfflineBackup.makeCanceler(job), daemonPlatform));
    }

    private void zip(OutputStream out, boolean close, AxBackupOp op) throws Exception {
        long t1 = Clock.millis();
        BBackupService.log.info("Ax Offline Backup starting...");
        if (op.log() != null) {
            op.log().message("Ax Offline Backup starting...");
        }
        op.zip = new ZipOutputStream(out);
        op.platform().checkSession();
        op.checkCanceled();
        this.processManifest(op);
        this.findRemoteStationFiles(op);
        this.findPlatformBackupFiles(op);
        this.addFilesToDist(op);
        if (op.log() != null) {
            op.log().start("Adding distribution manifest");
        }
        op.zip.putNextEntry(new ZipEntry("META-INF/dist.xml"));
        op.manifest().write((OutputStream)op.zip);
        if (op.log() != null) {
            op.log().endSuccess();
        }
        op.zip.finish();
        if (close) {
            op.zip.flush();
            op.zip.close();
        }
        if (op.log() != null) {
            op.log().success("Backup successful");
        }
        if (op.job() != null) {
            op.job().setProgress(100);
        }
        long t2 = Clock.millis();
        BBackupService.log.info("Finished backup, " + op.totalFilesCreated() + " files [" + (t2 - t1) + "ms]");
    }

    private void processManifest(AxBackupOp op) throws Exception {
        op.manifest().setInstallableName("backupdist");
        op.manifest().setInstallableVersion(new BVersion("Tridium", "0"));
        op.manifest().setBuildDate(BAbsTime.now());
        op.manifest().setBuildHost(Sys.getHostName());
        if (!op.platform().getAllowStationRestart()) {
            op.manifest().setRebootRequired(true);
        }
        op.manifest().setNoRunningApp(true);
        op.manifest().setUpdateModuleContent(op.moduleContent());
        op.manifest().setTargetOs(op.platform().getOsPart());
        op.manifest().setHostId(op.platform().getHostId());
        BTimeZone osTz = op.platform().getOsTimeZone();
        if (!osTz.isNull()) {
            op.manifest().setNewOsTimeZone(osTz);
        }
        op.manifest().addDir(op.manifest().getEntryPath(new FilePath("!stations"), false), true);
        op.manifest().addDir(op.manifest().getEntryPath(new FilePath("!lexicon"), false), true);
        op.manifest().setDescription("Offline backup of host \"" + op.platform().getHostName() + "\"");
        if (!op.platform().getNiagaraR2Enabled()) {
            BIFile platformBog = op.fileSpace().findFile(new FilePath("!lib/platform.bog"));
            if (platformBog != null) {
                op.manifest().setPlatformBog(platformBog, false);
            }
        } else {
            op.manifest().setIsStandalone(true);
        }
        op.manifest().setDaemonTcpIpSettings(op.session());
        op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getOsPart()));
        op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getArchPart()));
        BNrePart nre = op.platform().getNrePart();
        if (nre.isNull()) {
            throw new LocalizableRuntimeException("backup", "backup.error.badNRE", new Object[]{nre.getPartName()});
        }
        op.manifest().addDependency(this.getExactDependency((BPart)nre));
        BVmPart vm = op.platform().getVmPart();
        if (!vm.isNull() && !vm.getUnspecified()) {
            op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getVmPart()));
        }
        SlotCursor c = op.platform().getOtherParts().getProperties();
        while (c.next(BPart.class)) {
            BPart part = (BPart)c.get();
            op.manifest().addDependency(new BDependency(part.getPartName(), BVersion.makeZero(), part.getType().getTypeSpec()));
        }
        if (op.brandId() != null) {
            op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getBrandPart()));
        }
        if (!op.platform().getNiagaraR2Enabled()) {
            if (op.log() != null) {
                op.log().start("Analyzing modules");
            }
            BModuleList modules = op.platform().getModuleList();
            op.checkCanceled();
            modules.init();
            op.checkCanceled();
            SlotCursor c2 = modules.getModules().getProperties();
            while (c2.next(BModuleInstallable.class)) {
                BModuleInstallable mi = (BModuleInstallable)c2.get();
                op.manifest().addDependency(this.getExactDependency((BPart)mi.getModulePart()));
            }
        }
        if (op.log() != null) {
            op.log().endSuccess();
        }
    }

    private BDependency getExactDependency(BPart part) {
        return new BDependency(part.getPartName(), part.getVersion(), BVersionRelation.exact, part.getType().getTypeSpec());
    }

    private void findStationBackupFiles(BIFile stationHome, String stationName, Array<FileTuple> acc, AxBackupOp op) throws Exception {
        String filesToParse = this.getOfflineExcludeFiles();
        BOrdList dirsToSplit = this.getOfflineExcludeDirectories();
        PatternFilter[] excludeFiles = PatternFilter.parseList((String)filesToParse, (String)";");
        BOrd[] excludeDirs = dirsToSplit.toArray();
        TreeSet<FilePath> excludePaths = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
        for (BOrd excludeDir : excludeDirs) {
            excludePaths.add(this.getStationFilePath(excludeDir));
        }
        this.listBackupFiles(stationHome, stationName, excludeFiles, excludePaths, acc);
    }

    private void findRemoteStationFiles(AxBackupOp op) throws Exception {
        BDirectory stationsDir = (BDirectory)op.fileSpace().findFile(new FilePath("!stations"));
        if (stationsDir != null) {
            BIFile[] kids;
            for (BIFile kid : kids = stationsDir.listFiles()) {
                BDirectory stationDir;
                BBogFile configBog;
                if (!(kid instanceof BDirectory) || (configBog = (BBogFile)(stationDir = (BDirectory)kid).getNavChild("config.bog")) == null) continue;
                try {
                    BComponent root = (BComponent)new ValueDocDecoder((BIFile)configBog).decodeDocument();
                    BBackupService backupService = this.findUnmountedBackupService(root);
                    if (backupService == null) {
                        throw new NullPointerException("Backup Service not found");
                    }
                    this.setOfflineExcludeDirectories(backupService.getOfflineExcludeDirectories());
                    this.setOfflineExcludeFiles(backupService.getExcludeFiles());
                    BOrdList platformBackupFiles = (BOrdList)backupService.get("platformBackupFiles");
                    if (platformBackupFiles != null) {
                        this.add("platformBackupFiles", (BValue)platformBackupFiles);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.findStationBackupFiles((BIFile)stationDir, stationDir.getFileName(), op.files(), op);
            }
        }
    }

    private void findPlatformBackupFiles(AxBackupOp op) throws Exception {
        BOrd[] securityOrds;
        BOrd[] platformOrds;
        String filesToParse = this.getOfflineExcludeFiles();
        filesToParse = filesToParse + ";platform.bog;.data";
        PatternFilter[] excludeFiles = PatternFilter.parseList((String)filesToParse, (String)";");
        TreeSet<FilePath> excludePaths = new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE);
        excludePaths.add(new FilePath("!security"));
        excludePaths.add(new FilePath("!workbench/security"));
        excludePaths.add(new FilePath("!stations"));
        BOrdList list = op.platformBackupOrds();
        if (op.fileSpace().findFile(this.getPlatformFilePath(BOrd.make((String)"file:!niagaraR2"), op)) != null) {
            list = BOrdList.add((BOrdList)list, (BOrd)BOrd.make((String)"file:!niagaraR2"));
        }
        for (BOrd platformOrd : platformOrds = list.toArray()) {
            BIFile file = op.fileSpace().findFile(this.getPlatformFilePath(platformOrd, op));
            this.listBackupFiles(file, null, excludeFiles, excludePaths, op.files());
            if (!(file instanceof BDirectory)) continue;
            if (file.getFileName().equals("licenses")) {
                op.manifest().addDir(op.manifest().getEntryPath(file.getFilePath(), false), 0, false);
                continue;
            }
            op.manifest().addDir(op.manifest().getEntryPath(file.getFilePath(), false), -1, true);
        }
        for (BOrd securityOrd : securityOrds = DEFAULT_SECURITY_BACKUP.toArray()) {
            BIFile file = op.fileSpace().findFile(this.getPlatformFilePath(securityOrd, op));
            if (file == null) continue;
            this.listBackupFiles(file, null, new PatternFilter[0], new TreeSet<FilePath>((Comparator<FilePath>)FilePathComparator.INSTANCE), op.files());
            if (file.getFileName().contains("ssl.tks")) {
                op.manifest().addFile(op.manifest().getEntryPath(file.getFilePath(), false), 0);
                continue;
            }
            op.manifest().addFile(op.manifest().getEntryPath(file.getFilePath(), false), 1);
        }
    }

    private void listBackupFiles(BIFile file, String stationName, PatternFilter[] excludeFiles, Set<FilePath> excludePaths, Array<FileTuple> acc) throws Exception {
        BIFile[] backupFiles;
        if (file == null) {
            return;
        }
        if (!file.isDirectory()) {
            String name = file.getFileName();
            for (PatternFilter excludeFile : excludeFiles) {
                if (!excludeFile.accept(name)) continue;
                return;
            }
            acc.add((Object)new FileTuple(stationName, file));
            return;
        }
        if (excludePaths.contains(file.getFilePath())) {
            return;
        }
        BIDirectory dir = (BIDirectory)file;
        for (BIFile backupFile : backupFiles = dir.listFiles()) {
            this.listBackupFiles(backupFile, stationName, excludeFiles, excludePaths, acc);
        }
    }

    private BBackupService findUnmountedBackupService(BComponent component) {
        if (component instanceof BBackupService) {
            return (BBackupService)component;
        }
        SlotCursor c = component.getProperties();
        if (c.next(BBackupService.class)) {
            return (BBackupService)c.get();
        }
        c = component.getProperties();
        while (c.next(BComponent.class)) {
            BBackupService result = this.findUnmountedBackupService((BComponent)c.get());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void addFilesToDist(AxBackupOp op) throws Exception {
        FileTuple[] files;
        for (FileTuple file : files = (FileTuple[])op.files().trim()) {
            op.checkCanceled();
            BIFile f = file.file;
            InputStream in = f.getInputStream();
            if (f.getFileName().equals("daemon.properties")) {
                Properties daemonProperties = new Properties();
                daemonProperties.load(in);
                if (daemonProperties.containsKey("_password")) {
                    daemonProperties.remove("user");
                    daemonProperties.remove("_password");
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                daemonProperties.store(out, "Do not modify the contents of this file");
                out.flush();
                out.close();
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                in = new ByteArrayInputStream(out.toByteArray());
            }
            FilePath path = f.getFilePath();
            String entryPath = op.manifest().getEntryPath(path, file.stationName, false);
            if (op.log() != null) {
                op.log().start("Writing : " + entryPath);
            }
            ZipEntry entry = new ZipEntry(entryPath);
            entry.setTime(f.getLastModified().getMillis());
            op.zip.putNextEntry(entry);
            BajaFileUtil.pipe((InputStream)in, (OutputStream)op.zip);
            op.zip.closeEntry();
            in.close();
            op.notifyFileCreated();
            if (op.log() == null) continue;
            op.log().endSuccess();
        }
    }

    private FilePath getPlatformFilePath(BOrd ord, AxBackupOp op) throws Exception {
        OrdQuery[] q = ord.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            FilePath p = (FilePath)q[i];
            if (p.isStationHomeAbsolute()) {
                throw new IllegalStateException(p.getBody() + " cannot be station home absolute");
            }
            if (op == null) {
                return p;
            }
            return op.manifest().getNormalFilePath(p, false);
        }
        return null;
    }

    private FilePath getStationFilePath(BOrd ord) throws Exception {
        OrdQuery[] q = ord.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            FilePath p = (FilePath)q[i];
            if (!p.isStationHomeAbsolute()) {
                throw new IllegalStateException(p.getBody() + " cannot be station home absolute");
            }
            return p;
        }
        return null;
    }

    public static BBackupService.ICanceler makeCanceler(BJob job) {
        return job == null ? BBackupService.NULL_CANCELER : new BBackupService.JobCanceler(job);
    }

    public BIcon getIcon() {
        return icon;
    }

    private class AxBackupOp {
        private DistributionManifest manifest = null;
        private BJob job = null;
        private JobLog log = null;
        private BRemoteDaemonPlatform platform = null;
        private BFileSpace fileSpace = null;
        private int totalFilesCreated = 0;
        private Array<FileTuple> files = new Array(FileTuple.class);
        private BBackupService.ICanceler canceler = null;
        public ZipOutputStream zip = null;

        public AxBackupOp(BJob job, BRemoteDaemonPlatform platform) {
            this(job, BAxOfflineBackup.makeCanceler(job), platform);
        }

        public AxBackupOp(BJob job, BBackupService.ICanceler canceler, BRemoteDaemonPlatform platform) {
            this.job = job;
            this.canceler = canceler == null ? BBackupService.NULL_CANCELER : canceler;
            this.platform = platform;
            if (platform == null) {
                throw new IllegalStateException("platform is unavailable");
            }
            this.manifest = DistributionManifest.make();
        }

        public AxBackupOp(JobLog log, BBackupService.ICanceler canceler, BRemoteDaemonPlatform platform) {
            this.canceler = canceler == null ? BBackupService.NULL_CANCELER : canceler;
            this.log = log;
            this.platform = platform;
            if (platform == null) {
                throw new IllegalStateException("platform is unavailable");
            }
            this.manifest = DistributionManifest.make();
        }

        public String brandId() throws Exception {
            if (this.platform == null) {
                return null;
            }
            BBrandPart part = this.platform.getBrandPart();
            return part.isNull() ? null : part.getPartName();
        }

        public BModuleContent moduleContent() throws Exception {
            return this.platform() == null ? null : this.platform().getModuleContent();
        }

        public BDaemonSession session() {
            return this.platform() == null ? null : this.platform().getDaemonSession();
        }

        public BFileSpace fileSpace() {
            if (this.fileSpace == null) {
                if (this.platform() == null) {
                    return null;
                }
                this.fileSpace = this.platform() instanceof BRemoteDaemonPlatform ? new BCachedDaemonFileSpace(this.session(), true, false, false, null, null, null, new AutoCloseable[0]) : BFileSystem.INSTANCE;
            }
            return this.fileSpace;
        }

        public BJob job() {
            return this.job;
        }

        public JobLog log() {
            if (this.log == null && this.job != null) {
                this.log = this.job.log();
            }
            return this.log;
        }

        public BDaemonPlatform platform() {
            return this.platform;
        }

        public void checkCanceled() {
            if (this.canceler.isCanceled()) {
                throw new JobCancelException();
            }
            if (this.job != null) {
                this.job.heartbeat();
            }
        }

        public BOrdList platformBackupOrds() {
            Property p = BAxOfflineBackup.this.getProperty("platformBackupFiles");
            return p == null ? DEFAULT_PLATFORM_BACKUP : (BOrdList)BAxOfflineBackup.this.get(p);
        }

        public int totalFilesCreated() {
            return this.totalFilesCreated;
        }

        public void notifyFileCreated() {
            ++this.totalFilesCreated;
            if (this.job != null) {
                this.job.setProgress(10 + 90 * this.totalFilesCreated / this.files.size());
            }
        }

        public DistributionManifest manifest() {
            return this.manifest;
        }

        public Array<FileTuple> files() {
            return this.files;
        }
    }

    private static class FileTuple {
        public BIFile file;
        public String stationName;

        public FileTuple(String stationName, BIFile file) {
            this.file = file;
            this.stationName = stationName;
        }
    }
}

