/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.writer;

import com.tridium.forge.fileuploadclient.FileConfig;
import com.tridium.forge.fileuploadclient.FileUploadStatus;
import com.tridium.forge.fileuploadclient.IFileUploadStatusHandler;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileUploadStatusHandler
implements IFileUploadStatusHandler {
    private Logger logger;

    FileUploadStatusHandler(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void notifyUploadStatus(FileConfig fileConfig, FileUploadStatus fileUploadStatus) {
        if (fileUploadStatus == FileUploadStatus.FILE_UPLOAD_STARTED) {
            this.logger.log(Level.INFO, "File Upload Started for " + fileConfig.getFileDisplayName());
        }
        if (fileUploadStatus == FileUploadStatus.FILE_UPLOAD_COMPLETE) {
            this.logger.log(Level.INFO, "File Upload Completed for " + fileConfig.getFileDisplayName());
            this.deleteFile(fileConfig.getFileName());
        }
        if (fileUploadStatus == FileUploadStatus.FILE_UPLOAD_ERROR) {
            this.logger.log(Level.SEVERE, "File Upload Failed for " + fileConfig.getFileDisplayName());
            this.deleteFile(fileConfig.getFileName());
        }
    }

    private void deleteFile(String fileName) {
        File source = new File(fileName);
        this.logger.log(Level.INFO, () -> "File deleted " + source.delete());
    }
}

