/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.search.ui;

import com.tridium.search.ux.BSearchWidget;
import com.tridium.ui.swing.BSwingWidget;
import com.tridium.workbench.web.browser.BWebBrowser;
import com.tridium.workbench.web.browser.BWebWbSideBar;
import com.tridium.workbench.web.browser.BWebWidget;
import javax.baja.agent.AgentInfo;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.search.BSearchService;
import javax.baja.security.BPermissions;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BSearchSideBar
extends BWebWbSideBar {
    public static final Type TYPE = Sys.loadType(BSearchSideBar.class);
    static final Lexicon lex = Lexicon.make((String)"search");
    static final String unavailableText = lex.getText("SearchSideBar.error.noSearchService");

    public Type getType() {
        return TYPE;
    }

    protected AgentInfo getWebWidgetAgentInfo() {
        return BSearchWidget.TYPE.getTypeInfo().getAgentInfo();
    }

    protected OrdTarget getWebWidgetOrdTarget() {
        OrdTarget viewTarget;
        OrdTarget searchTarget = null;
        BWbShell shell = this.getWbShell();
        if (shell != null && (viewTarget = shell.getActiveOrdTarget()) != null) {
            BOrd ord = BOrd.make((BOrd)viewTarget.getOrd(), (String)"service:search:SearchService");
            try {
                searchTarget = ord.resolve(viewTarget.get());
                BPermissions permissions = searchTarget.getPermissionsForTarget();
                if (!permissions.hasOperatorInvoke() || !permissions.hasOperatorRead()) {
                    searchTarget = null;
                } else {
                    BSearchService searchService = (BSearchService)searchTarget.get();
                    searchService.lease();
                    if (!searchService.isOperational()) {
                        searchTarget = null;
                    }
                }
            }
            catch (Exception e) {
                searchTarget = null;
            }
        }
        return searchTarget;
    }

    protected String getUnavailableContentText() {
        return unavailableText;
    }

    public void webWidgetStarted(BWebWidget webWidget) {
        super.webWidgetStarted(webWidget);
        try {
            ((BSwingWidget)((BWebBrowser)this.getBrowser().get()).getTransferWidget()).setContentKeyListener(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

