/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BInfoList;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.tagdictionary.BTagGroupInfoList;
import javax.baja.tagdictionary.BTagInfo;

@NiagaraType
public class BTagInfoList
extends BInfoList
implements Iterable<TagInfo> {
    public static final Type TYPE = Sys.loadType(BTagInfoList.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public Iterator<TagInfo> iterator() {
        return SlotCursorIterator.iterator((SlotCursor)this.getProperties(), TagInfo.class);
    }

    public boolean containsTagId(Id id) {
        return this.getTag(id).isPresent();
    }

    public Optional<TagInfo> getTag(Id id) {
        SlotCursor tagInfos = this.getProperties();
        while (tagInfos.next(TagInfo.class)) {
            TagInfo tagInfo = (TagInfo)tagInfos.get();
            if (!tagInfo.getTagId().equals((Object)id)) continue;
            return Optional.of(tagInfo);
        }
        return Optional.empty();
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!(value instanceof TagInfo)) {
            TagDictionaryUtil.handleIllegalChild(this, value, context);
        }
        if (this.checkContext(context)) {
            return;
        }
        if (this.getParent() instanceof BTagGroupInfo) {
            return;
        }
        if (this.isDictionaryFrozen()) {
            throw new LocalizableRuntimeException("tagdictionary", "frozenDictionary.checkAdd");
        }
        BTagDictionary td = this.getTagDictionary();
        if (td == null) {
            return;
        }
        Id newId = Id.newId((String)td.getNamespace(), (String)name);
        BTagGroupInfoList tagGroupInfos = td.getTagGroupDefinitions();
        if (tagGroupInfos.containsTagId(newId)) {
            throw new IllegalNameException("tagdictionary", "tagInfo.duplicateTagId", (Object[])new String[]{newId.toString()});
        }
    }

    @Override
    public void checkRename(Property property, String newName, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        BValue bValue = this.get(property);
        if (bValue instanceof BTagInfo) {
            if (this.isDictionaryFrozen()) {
                throw new IllegalNameException("tagdictionary", "frozenDictionary.checkRename", (Object[])new String[]{newName});
            }
            BTagDictionary td = this.getTagDictionary();
            Id newId = Id.newId((String)td.getNamespace(), (String)newName);
            BTagGroupInfoList tagGroupInfos = td.getTagGroupDefinitions();
            if (tagGroupInfos.containsTagId(newId)) {
                throw new IllegalNameException("tagdictionary", "tagInfo.duplicateTagId", (Object[])new String[]{newId.toString()});
            }
        }
    }

    @Override
    public void checkRemove(Property property, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        if (this.getParent() instanceof BTagGroupInfo) {
            return;
        }
        if (this.isDictionaryFrozen()) {
            throw new LocalizableRuntimeException("tagdictionary", "frozenDictionary.checkRemove");
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        BValue value = this.get(property);
        if (value instanceof BTagInfo) {
            ((BTagInfo)value).tagRenamed();
        }
    }
}

