/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.tagdictionary.condition.BAlways;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.Optional;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMarker;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BIDataPolicy;
import javax.baja.tag.DataPolicy;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionary;
import javax.baja.tagdictionary.BTagInfoList;
import javax.baja.tagdictionary.BTagRuleCondition;
import javax.baja.tagdictionary.data.BDataPolicy;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="validity", type="BTagRuleCondition", defaultValue="new BAlways()")
@NiagaraAction(name="addDataPolicy", parameterType="baja:DynamicEnum", defaultValue="BDynamicEnum.DEFAULT")
public abstract class BTagInfo
extends BComponent
implements TagInfo,
BIDataPolicy,
BIRestrictedComponent {
    public static final Property validity = BTagInfo.newProperty((int)0, (BValue)new BAlways(), null);
    public static final Action addDataPolicy = BTagInfo.newAction((int)0, (BValue)BDynamicEnum.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BTagInfo.class);
    private static final BIcon icon = BIcon.std((String)"tag.png");
    private Id tagId;

    public BTagRuleCondition getValidity() {
        return (BTagRuleCondition)this.get(validity);
    }

    public void setValidity(BTagRuleCondition v) {
        this.set(validity, (BValue)v, null);
    }

    public void addDataPolicy(BDynamicEnum parameter) {
        this.invoke(addDataPolicy, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BTagInfo() {
    }

    public void started() {
        this.updateAddDataPolicyActionFlags();
    }

    public void tagRenamed() {
        this.tagId = null;
        this.tagId = this.getTagId();
    }

    public Optional<TagDictionary> getDictionary() {
        return BTagDictionary.getParentDictionary(this);
    }

    public Id getTagId() {
        if (this.isRunning() && this.tagId != null) {
            return this.tagId;
        }
        this.tagId = TagDictionaryUtil.generateId(this, this::getDictionary);
        return this.tagId;
    }

    public boolean isIdealFor(Type type) {
        return this.getValidity().testIdealMatch(type);
    }

    public boolean isValidFor(Entity entity) {
        return this.getValidity().test(entity);
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context context) {
        if (!(parent instanceof BTagInfoList)) {
            TagDictionaryUtil.handleIllegalParent(parent, this, context);
        }
    }

    public Optional<DataPolicy> getDataPolicy() {
        BDataPolicy[] children = (BDataPolicy[])this.getChildren(BDataPolicy.class);
        if (children == null || children.length == 0) {
            return Optional.empty();
        }
        return Optional.of(children[0]);
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (context != null && context.equals(Context.commit)) {
            return;
        }
        if (value instanceof BDataPolicy) {
            if (this.getDataPolicy().isPresent()) {
                throw new LocalizableRuntimeException("tagdictionary", "tagGroupInfo.oneDataPolicy");
            }
            if (this.getDefaultValue().getType().is(BMarker.TYPE)) {
                throw new LocalizableRuntimeException("tagdictionary", "tagInfo.dataPolicyNotValidOnMarkerTag");
            }
        }
    }

    public void added(Property p, Context cx) {
        if (this.get(p).getType().is(BDataPolicy.TYPE)) {
            this.updateAddDataPolicyActionFlags();
        }
    }

    public void removed(Property p, BValue oldValue, Context cx) {
        if (oldValue.getType().is(BDataPolicy.TYPE)) {
            this.updateAddDataPolicyActionFlags();
        }
    }

    private void updateAddDataPolicyActionFlags() {
        if (this.getDefaultValue().getType().is(BMarker.TYPE) || this.getDataPolicy().isPresent()) {
            this.setFlags((Slot)addDataPolicy, this.getFlags((Slot)addDataPolicy) | 4);
        } else {
            this.setFlags((Slot)addDataPolicy, this.getFlags((Slot)addDataPolicy) & 0xFFFFFFFB);
        }
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(addDataPolicy)) {
            TypeInfo[] concreteTypes = Sys.getRegistry().getConcreteTypes(BDataPolicy.TYPE.getTypeInfo());
            String[] tags = new String[concreteTypes.length];
            for (int i = 0; i < concreteTypes.length; ++i) {
                tags[i] = SlotPath.escape((String)concreteTypes[i].getTypeSpec().toString());
            }
            BEnumRange range = BEnumRange.make((String[])tags);
            return BDynamicEnum.make((int)0, (BEnumRange)range);
        }
        return super.getActionParameterDefault(action);
    }

    public void doAddDataPolicy(BDynamicEnum selected) {
        BTypeSpec typeSpec = BTypeSpec.make((String)SlotPath.unescape((String)selected.getTag()));
        this.add("dp_" + this.getName(), typeSpec.getInstance().asValue());
    }

    public synchronized boolean equivalent(Object obj) {
        if (!(obj instanceof BTagInfo)) {
            return false;
        }
        try {
            this.updateAddDataPolicyActionFlags();
            ((BTagInfo)((Object)obj)).updateAddDataPolicyActionFlags();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.equivalent(obj);
    }

    public BIcon getIcon() {
        return icon;
    }
}

