/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.tagdictionary;

import com.tridium.tagdictionary.util.TagDictionaryUtil;
import java.util.Iterator;
import java.util.Optional;
import javax.baja.collection.SlotCursorIterator;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.RelationInfo;
import javax.baja.tag.TagDictionary;
import javax.baja.tagdictionary.BInfoList;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.tagdictionary.BTagDictionary;

@NiagaraType
public class BRelationInfoList
extends BInfoList
implements Iterable<RelationInfo> {
    public static final Type TYPE = Sys.loadType(BRelationInfoList.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (!(value instanceof RelationInfo)) {
            TagDictionaryUtil.handleIllegalChild(this, value, context);
        }
        super.checkAdd(name, value, flags, facets, context);
    }

    public Optional<TagDictionary> getDictionary() {
        return BTagDictionary.getParentDictionary(this);
    }

    public boolean containsRelationId(Id id) {
        return this.getRelation(id).isPresent();
    }

    public Optional<RelationInfo> getRelation(Id id) {
        Optional<TagDictionary> td = this.getDictionary();
        if (!td.isPresent() || !td.get().getNamespace().equals(id.getDictionary())) {
            return Optional.empty();
        }
        String name = id.getName();
        BValue rel = this.get(name);
        if (rel == null) {
            return Optional.empty();
        }
        if (rel instanceof RelationInfo && ((RelationInfo)rel).getRelationId().equals((Object)id)) {
            return Optional.of((RelationInfo)rel);
        }
        return Optional.empty();
    }

    public void renamed(Property property, String oldName, Context context) {
        BValue value = this.get(property);
        if (value instanceof BRelationInfo) {
            ((BRelationInfo)value).relationRenamed();
        }
    }

    @Override
    public Iterator<RelationInfo> iterator() {
        return SlotCursorIterator.iterator((SlotCursor)this.getProperties(), RelationInfo.class);
    }
}

