/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.util;

import com.tridium.sys.tag.ComponentTags;
import com.tridium.tagdictionary.BNiagaraTagDictionary;
import com.tridium.util.CompUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.TagDictionary;
import javax.baja.tag.TagDictionaryService;
import javax.baja.tag.TagInfo;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.tagdictionary.BTagGroupInfo;
import javax.baja.util.LexiconText;

public final class TagDictionaryUtil {
    private static final Pattern INDEXED_TAGS_SPLIT = Pattern.compile("\\s*;\\s*");
    private static final String ID_DICT_SEP = String.valueOf(':');
    private static final Logger logger = Logger.getLogger("tagdictionary");
    private static final LexiconText ILLEGAL_PARENT_WARNING = LexiconText.make((String)"tagdictionary", (String)"illegalParentWarning");
    private static final LexiconText ILLEGAL_CHILD_WARNING = LexiconText.make((String)"tagdictionary", (String)"illegalChildWarning");

    private TagDictionaryUtil() {
    }

    public static Set<Id> parseIndexedTags(String value, BTagDictionaryService service) {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(service, "service");
        value = value.trim();
        if (value.isEmpty()) {
            return Collections.emptySet();
        }
        String defaultNamespace = service.getDefaultNamespace();
        String[] qNames = INDEXED_TAGS_SPLIT.split(value);
        HashSet<Id> ids = new HashSet<Id>(qNames.length);
        Arrays.stream(qNames).filter(qName -> !qName.isEmpty()).forEach(qName -> {
            try {
                Id id = TagDictionaryUtil.prependDefaultIfMissingNamespace(qName, defaultNamespace);
                Optional<TagDictionary> dictionary = service.getTagDictionary(id.getDictionary());
                if (!dictionary.isPresent()) {
                    logger.warning(() -> "The namespace of QName \"" + qName + "\" in the indexedTags property does not match any tag dictionaries");
                } else {
                    boolean found = false;
                    Iterator tagInfos = dictionary.get().getTags();
                    while (tagInfos.hasNext()) {
                        TagInfo tagInfo = (TagInfo)tagInfos.next();
                        if (!tagInfo.getTagId().equals((Object)id)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        logger.warning(() -> "The name of QName \"" + qName + "\" in the indexedTags property does not match any tags in the dictionary with namespace " + id.getDictionary());
                    }
                }
                ids.add(id);
            }
            catch (Exception e) {
                logger.warning(() -> "Error converting qName \"" + qName + "\" in the indexedTags property to an ID; " + e);
                logger.log(Level.FINE, e, () -> "");
            }
        });
        return ids;
    }

    public static Id prependDefaultIfMissingNamespace(String qName, String defaultNamespace) {
        Objects.requireNonNull(qName, "qName");
        Id id = Id.newId((String)qName);
        if (!id.hasDictionary() && defaultNamespace != null) {
            id = Id.newId((String)defaultNamespace, (String)id.getName());
        }
        return id;
    }

    public static Id generateId(BComponent component, Supplier<Optional<TagDictionary>> dictionarySupplier) {
        Objects.requireNonNull(component, "component");
        Objects.requireNonNull(dictionarySupplier, "dictionarySupplier");
        String escName = component.getName();
        if (escName == null) {
            throw new IllegalStateException("Component of type " + component.getType() + " is not mounted.");
        }
        String name = SlotPath.unescape((String)escName);
        String[] nameSplit = name.split(ID_DICT_SEP);
        if (nameSplit.length == 2) {
            return Id.newId((String)name);
        }
        TagDictionary dictionary = dictionarySupplier.get().orElseThrow(() -> new IllegalStateException("Component of type " + component.getType() + " is not in a dictionary."));
        String namespace = dictionary.getNamespace();
        if (namespace.isEmpty()) {
            throw new IllegalStateException("Dictionary namespace undefined");
        }
        return Id.newId((String)namespace, (String)escName);
    }

    public static void handleIllegalChild(BComponent parent, BValue child, Context context) {
        BComponentSpace space = parent.getComponentSpace();
        if (space != null && space.isProxyComponentSpace()) {
            return;
        }
        if (context != null && context != Context.decoding) {
            throw new IllegalChildException("baja", "IllegalChildException.parentAndChild", new Object[]{parent.getType(), child.getType()});
        }
        logger.warning(ILLEGAL_CHILD_WARNING.getText(context, new Object[]{child.getType(), parent.getType(), parent.getSlotPathOrd()}));
    }

    public static void handleIllegalParent(BComponent parent, BComponent child, Context context) {
        if (context != null && context != Context.decoding) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), child.getType()});
        }
        logger.warning(ILLEGAL_PARENT_WARNING.getText(context, new Object[]{parent.getType(), parent.getSlotPathOrd(), child.getType(), child.getName()}));
    }

    public static void updateTagGroupRelations(BComponent root, Logger logger) {
        TagDictionaryService tdService = root.getTagDictionaryService();
        if (tdService instanceof BTagDictionaryService) {
            BComponent[] childComps;
            BTagDictionaryService service = (BTagDictionaryService)tdService;
            BTagGroupInfo[] descendants = (BTagGroupInfo[])CompUtil.getDescendants((BComponent)service, BTagGroupInfo.class);
            ArrayList<BTagGroupInfo> tagGroups = new ArrayList<BTagGroupInfo>(descendants.length);
            Collections.addAll(tagGroups, descendants);
            TagDictionaryUtil.updateTagGroupRelations(root, tagGroups, logger);
            for (BComponent childComp : childComps = (BComponent[])CompUtil.getDescendants((BComponent)root, BComponent.class)) {
                TagDictionaryUtil.updateTagGroupRelations(childComp, tagGroups, logger);
            }
        }
    }

    private static void updateTagGroupRelations(BComponent root, Iterable<BTagGroupInfo> tagGroups, Logger logger) {
        if (new ComponentTags(root).getAll().isEmpty()) {
            return;
        }
        Collection tags = root.tags().getAll();
        for (Tag tag : tags) {
            boolean isTagGroupTag;
            String propName = SlotPath.escape((String)tag.getId().getQName());
            Property tagProp = root.getProperty(propName);
            if (tagProp == null || !(isTagGroupTag = root.getSlotFacets((Slot)tagProp).getb("tg__", false))) continue;
            boolean found = false;
            for (BTagGroupInfo tagGroup : tagGroups) {
                if (!tagGroup.getGroupId().equals((Object)tag.getId())) continue;
                TagDictionaryUtil.removeTagGroupDirectTags(root, tagGroup);
                BRelation addRelation = new BRelation(BNiagaraTagDictionary.TAG_GROUP_RELATION, tagGroup.getSlotPathOrd());
                if (!TagDictionaryUtil.hasRelation(addRelation, root)) {
                    logger.fine(() -> "adding tgr: " + addRelation);
                    root.add("r?", (BValue)addRelation, 1, null);
                }
                found = true;
                break;
            }
            if (found) continue;
            logger.warning(() -> "Tag group not found in station TagDictionaryService! : " + tag.getId());
        }
    }

    private static void removeTagGroupDirectTags(BComponent component, BTagGroupInfo tagGroup) {
        Iterator<TagInfo> tagInfos = tagGroup.getTags();
        while (tagInfos.hasNext()) {
            TagInfo tagInfo = tagInfos.next();
            TagDictionaryUtil.removeDirectTag(component, tagInfo.getTagId(), tagInfo.getDefaultValue());
        }
        TagDictionaryUtil.removeDirectTag(component, tagGroup.getGroupId(), null);
    }

    private static void removeDirectTag(BComponent component, Id id, BIDataValue defaultValue) {
        String tagPropName = SlotPath.escape((String)id.getQName());
        Property property = component.getProperty(tagPropName);
        if (property != null && (defaultValue == null || component.get(property).equivalent((Object)defaultValue))) {
            logger.fine(() -> "removeDirectTag: " + component.getName() + '.' + property.getName());
            component.remove(property, Context.decoding);
        }
    }

    private static boolean hasRelation(BRelation relation, BComponent component) {
        boolean hasRelation = false;
        for (BRelation existingRelation : (BRelation[])component.getChildren(BRelation.class)) {
            if (!existingRelation.getId().equals((Object)relation.getId()) || !existingRelation.getEndpointOrd().equals((Object)relation.getEndpointOrd())) continue;
            hasRelation = true;
            break;
        }
        return hasRelation;
    }

    public static List<BComponent> getComponents(BComponent base) {
        BComponent[] descendants = (BComponent[])CompUtil.getDescendants((BComponent)base, BComponent.class);
        ArrayList<BComponent> components = new ArrayList<BComponent>(descendants.length);
        Collections.addAll(components, descendants);
        return components;
    }

    public static List<BTagGroupInfo> getTagGroups(BTagDictionaryService service) {
        BTagGroupInfo[] descendants = (BTagGroupInfo[])CompUtil.getDescendants((BComponent)service, BTagGroupInfo.class);
        ArrayList<BTagGroupInfo> tagGroups = new ArrayList<BTagGroupInfo>(descendants.length);
        Collections.addAll(tagGroups, descendants);
        return tagGroups;
    }

    public static List<ComponentTagGroupChoices> listPotentialTagGroupsFromTags(BComponent comp) {
        ArrayList<ComponentTagGroupChoices> retList = new ArrayList<ComponentTagGroupChoices>();
        List<BTagGroupInfo> tagGroups = TagDictionaryUtil.getTagGroups((BTagDictionaryService)comp.getTagDictionaryService());
        List<BComponent> entities = TagDictionaryUtil.getComponents(comp);
        return TagDictionaryUtil.listPotentialTagGroupsFromTags(entities, tagGroups, retList);
    }

    public static List<ComponentTagGroupChoices> listPotentialTagGroupsFromTags(List<BComponent> entities, List<BTagGroupInfo> tgInfos, List<ComponentTagGroupChoices> retList) {
        for (Entity entity : entities) {
            BComponent comp = (BComponent)entity;
            ComponentTags componentTags = new ComponentTags(comp);
            for (BTagGroupInfo tgInfo : tgInfos) {
                boolean tgRelationExist = false;
                for (BRelation relation : comp.getComponentRelations()) {
                    if (!relation.getId().equals((Object)BNiagaraTagDictionary.TAG_GROUP_RELATION)) continue;
                    if (relation.isInbound()) break;
                    Entity entity2 = relation.getEndpoint();
                    if (!(entity2 instanceof BTagGroupInfo) || !((BTagGroupInfo)entity2).getGroupId().equals((Object)tgInfo.getGroupId())) continue;
                    tgRelationExist = true;
                    break;
                }
                Iterator<TagInfo> tagList = tgInfo.getTagList().iterator();
                boolean hasAllGroupTags = tagList.hasNext();
                while (tagList.hasNext()) {
                    TagInfo tgTag = tagList.next();
                    if (componentTags.contains(tgTag.getTagId())) continue;
                    hasAllGroupTags = false;
                    break;
                }
                if (!hasAllGroupTags) continue;
                retList.add(new ComponentTagGroupChoices(comp, tgInfo, false, tgRelationExist));
            }
        }
        return retList;
    }

    public static boolean isInTemplate(BComponent comp) {
        if (comp.tags().get(BNiagaraTagDictionary.TEMPLATE).isPresent()) {
            return true;
        }
        for (BComplex parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            parent.loadSlots();
            if (!parent.asComponent().tags().get(Id.newId((String)"ntpl:template")).isPresent()) continue;
            return true;
        }
        return false;
    }

    public static class ComponentTagGroupChoices
    implements Comparable<ComponentTagGroupChoices> {
        private final BComponent comp;
        private final BTagGroupInfo tgInfo;
        private boolean select;
        private boolean removeTags;
        private final boolean inTemplate;
        private final boolean tgRelationExist;
        private static final String COMP_VECTOR = "comp?";
        private static final String COMP_ORD = "compOrd";
        private static final String TG_RELATION_EXIST = "tgExist";
        private static final String TAG_GROUP = "tagGroup";

        public ComponentTagGroupChoices(BComponent comp, BTagGroupInfo tgInfo, boolean inTemplate, boolean tgRelationExist) {
            this.comp = comp;
            this.tgInfo = tgInfo;
            this.inTemplate = inTemplate;
            this.tgRelationExist = tgRelationExist;
        }

        public BComponent getComponent() {
            return this.comp;
        }

        public BTagGroupInfo getTagGroupInfo() {
            return this.tgInfo;
        }

        public boolean isSelected() {
            return this.select;
        }

        public void setSelected(boolean select) {
            this.select = select;
        }

        public boolean isRemoveTags() {
            return this.removeTags;
        }

        public boolean isInTemplate() {
            return this.inTemplate;
        }

        public boolean isTgRelationExist() {
            return this.tgRelationExist;
        }

        public void setRemoveTags(boolean removeTags) {
            this.removeTags = removeTags;
        }

        public static void encodeToComponent(List<ComponentTagGroupChoices> ctgChoices, BComponent comp) {
            BComponent lastComp = null;
            BComponent wrapperComp = null;
            for (ComponentTagGroupChoices ctgChoice : ctgChoices) {
                BComponent thisComp = ctgChoice.getComponent();
                if (lastComp == null || !lastComp.equals((Object)thisComp)) {
                    wrapperComp = comp.get(comp.add(COMP_VECTOR, (BValue)new BComponent(), 1)).asComponent();
                    wrapperComp.add("compOrd?", (BValue)thisComp.getSlotPathOrd(), 1);
                    wrapperComp.add("tgExist?", (BValue)BBoolean.make((boolean)ctgChoice.isTgRelationExist()));
                    lastComp = thisComp;
                }
                wrapperComp.add("tagGroup?", (BValue)ctgChoice.getTagGroupInfo().getSlotPathOrd(), 1);
            }
        }

        public static List<ComponentTagGroupChoices> decodeFromComponent(BComponent comp, BComponent base) throws Exception {
            ArrayList<ComponentTagGroupChoices> compChoices = new ArrayList<ComponentTagGroupChoices>();
            for (BComponent wrapperComp : comp.getChildComponents()) {
                BOrd compOrd = (BOrd)wrapperComp.get(COMP_ORD);
                OrdTarget ordTarget = compOrd.resolve((BObject)base);
                BComponent thisComp = ordTarget.get().asComponent();
                boolean isInTemplate = TagDictionaryUtil.isInTemplate(thisComp);
                BBoolean tagGroupExists = (BBoolean)wrapperComp.get(TG_RELATION_EXIST);
                for (BOrd bOrd : (BOrd[])wrapperComp.getChildren(BOrd.class)) {
                    OrdTarget ordTarget1 = bOrd.resolve((BObject)base);
                    BComponent maybeComp = ordTarget1.get().asComponent();
                    if (!(maybeComp instanceof BTagGroupInfo)) continue;
                    BTagGroupInfo tgInfo = (BTagGroupInfo)maybeComp;
                    tgInfo.lease(3);
                    compChoices.add(new ComponentTagGroupChoices(thisComp, tgInfo, isInTemplate, tagGroupExists.getBoolean()));
                }
            }
            return compChoices;
        }

        public String getTagsString() {
            StringBuilder sb = new StringBuilder();
            Iterator<TagInfo> tagInfos = this.getTagGroupInfo().getTags();
            while (tagInfos.hasNext()) {
                sb.append(tagInfos.next().getTagId().getQName());
                if (tagInfos.hasNext()) {
                    sb.append(", ");
                    continue;
                }
                sb.append("->");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(ComponentTagGroupChoices tgc) {
            return this.getComponent().getSlotPath().toString().compareTo(tgc.getComponent().getSlotPath().toString());
        }
    }
}

