/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.relation;

import com.tridium.tagdictionary.relation.BParentDeviceRelation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;

@NiagaraType
public class BChildNullProxyPointRelation
extends BRelationInfo {
    public static final Type TYPE = Sys.loadType(BChildNullProxyPointRelation.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public Optional<Relation> getRelation(Entity entity) {
        BDevice device;
        if (entity instanceof BDevice) {
            List<BControlPoint> points = BParentDeviceRelation.getDescendantPoints((BDevice)entity, true);
            if (!points.isEmpty()) {
                return Optional.of(new BasicRelation(this.getRelationId(), (Entity)points.get(0), false));
            }
        } else if (BParentDeviceRelation.isPoint(entity, true) && (device = BParentDeviceRelation.getParentDevice((BControlPoint)entity)) != null) {
            return Optional.of(new BasicRelation(this.getRelationId(), (Entity)device, true));
        }
        return Optional.empty();
    }

    public void addRelations(Entity entity, Collection<Relation> relations) {
        BDevice device;
        if (entity instanceof BDevice) {
            Id relationId = this.getRelationId();
            for (BControlPoint point : BParentDeviceRelation.getDescendantPoints((BDevice)entity, true)) {
                relations.add((Relation)new BasicRelation(relationId, (Entity)point, false));
            }
        } else if (BParentDeviceRelation.isPoint(entity, true) && (device = BParentDeviceRelation.getParentDevice((BControlPoint)entity)) != null) {
            relations.add((Relation)new BasicRelation(this.getRelationId(), (Entity)device, true));
        }
    }
}

