/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tagdictionary.neqlize;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.baja.tag.Tag;

public final class TagsCandidateIterator
implements Iterator<Set<Tag>> {
    private final List<Tag> allTags;
    private final int allTagsSize;
    private int subsetSize = 1;
    private final int[] odometer;

    public TagsCandidateIterator(List<Tag> allTags) {
        this.allTags = allTags;
        this.allTagsSize = this.allTags.size();
        this.odometer = new int[this.allTagsSize];
    }

    @Override
    public boolean hasNext() {
        return this.subsetSize <= this.allTagsSize;
    }

    @Override
    public Set<Tag> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("subsetSize has already reached the tagsSize");
        }
        HashSet<Tag> subset = new HashSet<Tag>(this.subsetSize);
        for (int i = 0; i < this.subsetSize; ++i) {
            subset.add(this.allTags.get(this.odometer[i]));
        }
        this.adjustOdometer();
        return subset;
    }

    private void adjustOdometer() {
        for (int i = this.subsetSize - 1; i >= 0; --i) {
            int n = i;
            this.odometer[n] = this.odometer[n] + 1;
            this.incrementSubsequentPositions(i);
            if (!this.isLastValid()) continue;
            return;
        }
        if (!this.isLastValid()) {
            ++this.subsetSize;
            if (this.subsetSize <= this.allTagsSize) {
                this.odometer[0] = 0;
                this.incrementSubsequentPositions(0);
            }
        }
    }

    private void incrementSubsequentPositions(int i) {
        for (int j = i + 1; j < this.subsetSize; ++j) {
            this.odometer[j] = this.odometer[j - 1] + 1;
        }
    }

    private boolean isLastValid() {
        return this.odometer[this.subsetSize - 1] < this.allTagsSize;
    }
}

